% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{check_if_three_categories_are_mutually_exclusive}
\alias{check_if_three_categories_are_mutually_exclusive}
\title{Check If Three Categories Are Mutually Exclusive}
\usage{
check_if_three_categories_are_mutually_exclusive(
  label_cat_1,
  label_cat_2,
  label_cat_3,
  label_cat_missing = NULL,
  arg_cat_1 = rlang::caller_arg(label_cat_1),
  arg_cat_2 = rlang::caller_arg(label_cat_2),
  arg_cat_3 = rlang::caller_arg(label_cat_3),
  arg_cat_missing = rlang::caller_arg(label_cat_missing),
  error_call = rlang::caller_env()
)
}
\arguments{
\item{label_cat_1}{First vector to check for mutually exclusiveness with another vector.}

\item{label_cat_2}{Second vector to check for mutually exclusiveness with another vector.}

\item{label_cat_3}{Third vector to check for mutually exclusiveness with another vector}

\item{label_cat_missing}{Missing values vector to check for mutually exclusiveness with another vector
if needed.
Default: NULL}

\item{arg_cat_1}{An argument name as a string for the first vector.
This argument will be mentioned in error messages as the input that is at the origin of a problem.}

\item{arg_cat_2}{An argument name as a string for the second vector.
This argument will be mentioned in error messages as the input that is at the origin of a problem.}

\item{arg_cat_3}{An argument name as a string for the third vector.
This argument will be mentioned in error messages as the input that is at the origin of a problem.}

\item{arg_cat_missing}{An argument name as a string for the missing values vector.
This argument will be mentioned in error messages as the input that is at the origin of a problem.}

\item{error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
An error message if the three input categories are not mutually exclusive
}
\description{
Check if the three input categories are mutually exclusive from each other
}
\examples{
# No error
cat_1 <- c("typical")
cat_2 <- c("atypical")
cat_3 <- c("nonanginal")
cat_missing <- c("NA")
check_if_three_categories_are_mutually_exclusive(cat_1, cat_2, cat_3)
check_if_three_categories_are_mutually_exclusive(cat_1, cat_2, cat_3, cat_missing)

# Common labels found
cat_1 <- c("typical", "atypical", "nonanginal", "NA")
cat_2 <- c("typical", "atypical", "nonanginal", "NA")
cat_3 <- c("typical", "atypical", "nonanginal", "NA")
cat_missing <- c("typical", "atypical", "nonanginal", "NA")

try(check_if_three_categories_are_mutually_exclusive(cat_1, cat_2, cat_3))

try(check_if_three_categories_are_mutually_exclusive(cat_1, cat_2, cat_3, cat_missing))
}
\seealso{
\code{\link[rlang]{caller_arg}}, \code{\link[rlang]{stack}}
 \code{\link[cli]{cli_vec}}, \code{\link[cli]{cli_abort}}
}
