% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anonymize_age.R
\name{anonymize_age}
\alias{anonymize_age}
\title{Anonymize Age by Buckets}
\usage{
anonymize_age(x, method = c("10year", "hipaa"), custom_buckets = NULL)
}
\arguments{
\item{x}{A numeric vector of ages to anonymize}

\item{method}{Character string specifying bucketing method:
"10year" (default) uses 10-year buckets: 0-9, 10-19, 20-29, 30-39, 40-49, 50-59, 60-69, 70-79, 80-89, 90+
"hipaa" uses HIPAA-compliant buckets: 0-17, 18-64, 65-89, 90+}

\item{custom_buckets}{Optional named numeric vector for custom buckets.
Format: c("0-9" = 9, "10-19" = 19, "20-29" = 29, "90+" = Inf)}
}
\value{
A character vector of age buckets
}
\description{
Groups ages into buckets for privacy protection. Default uses 10-year buckets
(0-9, 10-19, etc.) which are useful for research. Ages 90+ are grouped together.
}
\examples{
ages <- c(25, 45, 67, 92, 15, 78)
anonymize_age(ages)  # Uses 10-year buckets by default
anonymize_age(ages, method = "hipaa")  # Use HIPAA buckets

}
