% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map2.R
\name{map2}
\alias{map2}
\alias{map2_lgl}
\alias{map2_int}
\alias{map2_dbl}
\alias{map2_chr}
\alias{map2_vec}
\alias{walk2}
\title{Map over two inputs}
\usage{
map2(.x, .y, .f, ..., .progress = FALSE)

map2_lgl(.x, .y, .f, ..., .progress = FALSE)

map2_int(.x, .y, .f, ..., .progress = FALSE)

map2_dbl(.x, .y, .f, ..., .progress = FALSE)

map2_chr(.x, .y, .f, ..., .progress = FALSE)

map2_vec(.x, .y, .f, ..., .ptype = NULL, .progress = FALSE)

walk2(.x, .y, .f, ..., .progress = FALSE)
}
\arguments{
\item{.x, .y}{A pair of vectors, usually the same length. If not, a vector
of length 1 will be recycled to the length of the other.}

\item{.f}{A function, specified in one of the following ways:
\itemize{
\item A named function.
\item An anonymous function, e.g. \verb{\\(x, y) x + y} or \code{function(x, y) x + y}.
\item A formula, e.g. \code{~ .x + .y}. Use \code{.x} to refer to the current
element of \code{x} and \code{.y} to refer to the current element of \code{y}.
No longer recommended.
}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Wrap a function with \code{\link[=in_parallel]{in_parallel()}} to declare that it should be performed
in parallel. See \code{\link[=in_parallel]{in_parallel()}} for more details.
Use of \code{...} is not permitted in this context.}

\item{...}{Additional arguments passed on to the mapped function.

We now generally recommend against using \code{...} to pass additional
(constant) arguments to \code{.f}. Instead use a shorthand anonymous function:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{# Instead of
x |> map(f, 1, 2, collapse = ",")
# do:
x |> map(\\(x) f(x, 1, 2, collapse = ","))
}\if{html}{\out{</div>}}

This makes it easier to understand which arguments belong to which
function and will tend to yield better error messages.}

\item{.progress}{Whether to show a progress bar. Use \code{TRUE} to turn on
a basic progress bar, use a string to give it a name, or see
\link{progress_bars} for more details.}

\item{.ptype}{If \code{NULL}, the default, the output type is the common type
of the elements of the result. Otherwise, supply a "prototype" giving
the desired type of output.}
}
\value{
The output length is determined by the length of the input.
The output names are determined by the input names.
The output type is determined by the suffix:
\itemize{
\item No suffix: a list; \code{.f()} can return anything.
\item \verb{_lgl()}, \verb{_int()}, \verb{_dbl()}, \verb{_chr()} return a logical, integer, double,
or character vector respectively; \code{.f()} must return a compatible atomic
vector of length 1.
\item \verb{_vec()} return an atomic or S3 vector, the same type that \code{.f} returns.
\code{.f} can return pretty much any type of vector, as long as its length 1.
\item \code{walk()} returns the input \code{.x} (invisibly). This makes it easy to
use in a pipe. The return value of \code{.f()} is ignored.
}

Any errors thrown by \code{.f} will be wrapped in an error with class
\link{purrr_error_indexed}.
}
\description{
These functions are variants of \code{\link[=map]{map()}} that iterate over two arguments at
a time.
}
\examples{
x <- list(1, 1, 1)
y <- list(10, 20, 30)

map2(x, y, \(x, y) x + y)
# Or just
map2(x, y, `+`)

# Split into pieces, fit model to each piece, then predict
by_cyl <- mtcars |> split(mtcars$cyl)
mods <- by_cyl |> map(\(df) lm(mpg ~ wt, data = df))
map2(mods, by_cyl, predict)
}
\seealso{
Other map variants: 
\code{\link{imap}()},
\code{\link{lmap}()},
\code{\link{map}()},
\code{\link{map_depth}()},
\code{\link{map_if}()},
\code{\link{modify}()},
\code{\link{pmap}()}
}
\concept{map variants}
