% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svarirf.R
\name{irf.pvarx}
\alias{irf.pvarx}
\title{Impulse Response Functions for panel SVAR models}
\usage{
\method{irf}{pvarx}(x, ..., n.ahead = 20, normf = NULL, w = NULL, MG_IRF = TRUE)
}
\arguments{
\item{x}{Panel VAR object of class '\code{pid}' or '\code{pvarx}' 
or a list of VAR objects that will be \link[=as.varx]{coerced} to '\code{varx}'.}

\item{...}{Currently not used.}

\item{n.ahead}{Integer. Number of periods to consider after the initial impulse, i.e. the horizon of the IRF.}

\item{normf}{Function. A given function that normalizes the \eqn{K \times S} input-matrix 
into an output matrix of same dimension. See the example in \code{\link{id.iv}} 
for the normalization of Jentsch and Lunsford (2021) 
that fixes the size of the impact response.}

\item{w}{Numeric, logical, or character vector. 
\eqn{N} numeric elements weighting the individual coefficients, or 
names or \eqn{N} logical elements selecting a subset from the 
individuals \eqn{i = 1, \ldots, N} for the MG estimation. If \code{NULL} 
(the default), all \eqn{N} individuals are included without weights.}

\item{MG_IRF}{Logical. If \code{TRUE} (the default), the mean-group of individual 
IRF is calculated in accordance with Gambacorta et al. (2014). If \code{FALSE}, 
the IRF is calculated for the mean-group of individual VAR estimates.}
}
\value{
A list of class '\code{svarirf}' holding the impulse response functions as a '\code{data.frame}'.
}
\description{
Calculates impulse response functions for panel VAR objects.
}
\examples{
data("PCAP")
names_k = c("g", "k", "l", "y")  # variable names
names_i = levels(PCAP$id_i)      # country names
L.data  = sapply(names_i, FUN=function(i) 
  ts(PCAP[PCAP$id_i==i, names_k], start=1960, end=2019, frequency=1), 
  simplify=FALSE)

# estimate and identify panel SVAR #
L.vars = lapply(L.data, FUN=function(x) vars::VAR(x, p=2, type="both"))
R.pid  = pid.chol(L.vars, order_k=names_k)

# calculate and plot MG-IRF #
library("ggplot2")
R.irf = irf(R.pid, n.ahead=60)
F.irf = plot(R.irf, selection=list(2:4, 1:2))
as.pplot(F.irf=F.irf, color_g="black", n.rows=3)$F.plot + guides(color="none")

}
\references{
Luetkepohl, H. (2005): 
  \emph{New Introduction to Multiple Time Series Analysis}, 
  Springer, 2nd ed.

Gambacorta L., Hofmann B., and Peersman G. (2014):
  "The Effectiveness of Unconventional Monetary Policy at the Zero Lower Bound: A Cross-Country Analysis",
  \emph{Journal of Money, Credit and Banking}, 46, pp. 615-642.

Jentsch, C., and Lunsford, K. G. (2021):
  "Asymptotically Valid Bootstrap Inference for Proxy SVARs",
  \emph{Journal of Business and Economic Statistics}, 40, pp. 1876-1891.
}
