% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohensf_to_peta2.r
\name{cohensf_to_peta2}
\alias{cohensf_to_peta2}
\title{Convert Cohen's f to Partial Eta Squared}
\usage{
cohensf_to_peta2(f)
}
\arguments{
\item{f}{A numeric vector of Cohen's f values.
Each value must be greater than or equal to 0.}
}
\value{
A numeric vector of partial eta squared values.
}
\description{
Converts Cohen's f to partial eta squared (\eqn{\eta_p^2})
using the standard definition in Cohen (1988).
}
\details{
The conversion is defined as:
\deqn{\eta_p^2 = \frac{f^2}{1 + f^2}}

This follows from the relationship: \eqn{f = \sqrt{\eta_p^2 / (1 - \eta_p^2)}}
}
\examples{
# Convert a single Cohen's f value
cohensf_to_peta2(0.25)

# Convert multiple values
cohensf_to_peta2(c(0.1, 0.25, 0.4))

}
\references{
Cohen, J. (1988). \emph{Statistical power analysis for the behavioral sciences} (2nd ed.).
Hillsdale, NJ: Lawrence Erlbaum Associates.
}
\seealso{
\link{peta2_to_cohensf}
}
