% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_text.R
\name{check_text}
\alias{check_text}
\title{Check Text For Potential Problems}
\usage{
check_text(text.var, file = NULL)
}
\arguments{
\item{text.var}{The text variable.}

\item{file}{A connection, or a character string naming the file to print to.
If \code{NULL} prints to the console.  Note that this is assigned as an 
attribute and passed to \code{print}.}
}
\value{
Returns a list with the following potential text faults reports:\cr
\describe{
  \item{non_character}{- Text that is non-character.}
  \item{missing_ending_punctuation}{- Text with no endmark at the end of the string.}
  \item{empty}{- Text that contains an empty element (i.e., \code{""}).}
  \item{double_punctuation}{- Text that contains two \pkg{qdap} punctuation marks in the same string.}
  \item{non_space_after_comma}{- Text that contains commas with no space after them.}
  \item{no_alpha}{- Text that contains string elements with no alphabetic characters.}
  \item{non_ascii}{- Text that contains non-ASCII characters.}
  \item{missing_value}{- Text that contains missing values (i.e., \code{NA}).}
  \item{containing_escaped}{- Text that contains escaped (see \code{?Quotes}).}
  \item{containing_digits}{- Text that contains digits.}
  \item{indicating_incomplete}{- Text that contains endmarks that are indicative of incomplete/trailing sentences (e.g., \code{...}).}
  \item{potentially_misspelled}{- Text that contains potentially misspelled words.}
}
}
\description{
Uncleaned text may result in errors, warnings, and incorrect results in 
subsequent analysis.  \code{check_text} checks text for potential problems 
and suggests possible fixes.  Potential text anomalies that are detected 
include: factors, missing ending punctuation, empty cells, double punctuation, 
non-space after comma, no alphabetic characters, non-ascii, missing value, 
and potentially misspelled words.
}
\note{
The output is a list but prints as a pretty formatted output with 
potential problem elements, the accompanying text, and possible suggestions 
to fix the text.
}
\examples{
\dontrun{
x <- c("i like", "i want. thet them .", "I am ! that|", "", NA, 
    "they,were there", ".", "   ", "?", "3;", "I like goud eggs!", 
    "i 4like...", "\\\\tgreat",  "She said \"yes\"")
check_text(x)
print(check_text(x), include.text=FALSE)

y <- c("A valid sentence.", "yet another!")
check_text(y)
}
}
\seealso{
\code{\link[qdap]{check_spelling_interactive}}
}
\keyword{check}
\keyword{spelling}
\keyword{text}
