% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa4.2.R
\name{qser2ar}
\alias{qser2ar}
\title{Autoregression (AR) Model of Quantile Series}
\usage{
qser2ar(
  y.qser,
  p = NULL,
  order.max = NULL,
  method = c("none", "gamm", "sp"),
  spar = "GCV"
)
}
\arguments{
\item{y.qser}{matrix or array of pre-calculated QSER, e.g., using \code{qser()}}

\item{p}{order of AR model (default = \code{NULL}: selected by AIC)}

\item{order.max}{maximum order for AIC if \code{p = NULL} (default = \code{NULL}: determined by \code{stats::ar()})}

\item{method}{quantile smoothing method: \code{"gamm"} for \code{mgcv::gamm()}, 
\code{"sp"} for \code{stats::smooth.spline()}, or \code{"none"} (default)}

\item{spar}{smoothing parameter for \code{stats::smooth.spline()} (default = \code{"GCV"})}
}
\value{
a list with the following elements:
  \item{A}{matrix or array of AR coefficients}
  \item{V}{vector or matrix of residual covariance}
  \item{p}{order of AR model}
  \item{n}{length of time series}
  \item{residuals}{matrix or array of residuals}
}
\description{
This function fits an autoregression (AR) model to quantile series (QSER) separately for each quantile level using \code{stats::ar()}.
}
