% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitAllTests.R
\name{FitAllTests}
\alias{FitAllTests}
\alias{CitTests}
\alias{CombineTests}
\alias{JoinTestOutputs}
\title{Determine false positive and true positive rates for known targets.}
\usage{
FitAllTests(cross, pheno1, pheno2, Q.chr, Q.pos, verbose = TRUE)

CitTests(LL, GG, TT)

CombineTests(comap, file)

JoinTestOutputs(comap, tests, file = NULL)
}
\arguments{
\item{cross}{object of class `cross`}

\item{pheno1}{first phenotype column number or character string name}

\item{pheno2}{second phenotype column number or character string name; if
more than one, then all phenotypes will be tested against `pheno1`}

\item{Q.chr}{QTL chromosome (number or label)}

\item{Q.pos}{QTL position in cM}

\item{verbose}{verbose printout if `TRUE}

\item{LL, GG, TT}{Numeric vectors corresponding to genotype}

\item{comap}{list result of `GetComappingTraits()`}

\item{file}{prefix for file names when running `FitAllTests()` in
parallel and saving test results in separate files
\code{\link[stats]{p.adjust}}}

\item{tests}{list object as list of `FitAllTests()` results, or of joined
output created by `JoinTestsOutputs()`}
}
\value{
List containing \item{Prec1,Prec2}{matrix of precision with rows for
significance level and columns for test; first is for all, second is for cis
candidates only} \item{Tp1,Tp2}{matrix of true positive rate with rows for
significance level and columns for test; first is for all, second is for cis
candidates only} \item{Fp1,Fp2}{matrix of false positive rate with rows for
significance level and columns for test; first is for all, second is for cis
candidates only}
}
\description{
Determine how well different tests do to predict candidates of regulation.
}
\details{
`FitAllTests()` invokes 7 tests. The hidden routine `CitTests()` is
invoked by call to `FitAllTests()`; this is hidden because we do not
recommend its use.

`JoinTestOutputs()` joins results of `FitAllTests()`, either
from a list `tests` or from a collection of files prefixed by
`file`. The joined tests from `JoinTestOutputs` are
summarized with `PrecTpFpMatrix()` using the biologically validated true
positives, false positives and precision, for the inferred causal relations.
We define a true positive as a statistically significant causal relation
between a gene and a putative target gene when the putative target gene
belongs to the known signature of the gene. Similarly, we define a false
positive as a statistically significant causal relation between a gene and a
putative target gene when the target gene does not belong to the signature.
(For the AIC and BIC methods that do not provide a p-value measuring the
significance of the causal call, we simply use the detected causal relations
in the computation of true and false positives). The validated precision is
computed as the ratio of true positives by the sum of true and false
positives. The `PrecTpFpMatrix` computes these measures to both all
genes, and to cis genes only. Simulations suggest only non-parametric tests
need to be adjusted using Benjamini-Hochberg via `p.adjust.np()`.
}
\examples{
\dontrun{
example(GetCandReg)
## Suppose y1 is causal with targets y2 and y3.
targets <- list(y1 = c("y2","y3"))

tests <- list()
for(k in seq(names(comap.targets))) {
  tests[[k]] <- FitAllTests(CMSTCross, pheno1 = names(comap.targets)[k],
                      pheno2 = comap.targets[[k]],
                      Q.chr = cand.reg[k, 4],
                      Q.pos = cand.reg[k, 5])
}
names(tests) <- names(comap.targets)
tests <- JoinTestOutputs(comap.targets, tests)

PrecTpFpMatrix(alpha = seq(0.01, 0.10, by = 0.01),
  val.targets = targets, all.orfs = CMSThigh$names, tests = tests,
  cand.reg = cand.reg, cis.cand.reg = cis.cand.reg)
}
}
\seealso{
\code{\link[stats]{p.adjust}}
}
\author{
Elias Chaibub Neto
}
\keyword{utilities}
