% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max.R
\name{quantile_highlod}
\alias{quantile_highlod}
\title{Compute Quantiles of High LOD Scores}
\usage{
quantile_highlod(
  x,
  probs = NULL,
  lod.thr = NULL,
  n.quant,
  n.pheno,
  max.quantile = TRUE,
  ...
)
}
\arguments{
\item{x}{A `highlod` object containing LOD scores.}

\item{probs}{A numeric vector of probabilities for quantiles. If `NULL`, quantiles are computed for all available data.}

\item{lod.thr}{LOD threshold for filtering scores. If `NULL`, no filtering is applied.}

\item{n.quant}{Maximum number of quantiles to compute.}

\item{n.pheno}{Number of phenotypes considered.}

\item{max.quantile}{Logical; if `TRUE`, returns only the maximum quantile values.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
A numeric vector or matrix of quantiles, depending on the input parameters.
}
\description{
The `quantile_highlod` function calculates quantiles of high LOD scores from a `highlod` object.
It is used to summarize the distribution of LOD scores across the genome.
}
\examples{
\dontrun{
highlod_obj <- highlod(scan1, lod.thr = 2.5)
quantiles <- quantile_highlod(highlod_obj, probs = seq(0.1, 0.9, by = 0.1))
}
}
