% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piped.R
\name{center}
\alias{center}
\title{Center ENA Data}
\usage{
center(x, add.meta = TRUE)
}
\arguments{
\item{x}{An `ena.set` object (typically after `sphere_norm()`) or a numeric matrix.}

\item{add.meta}{A logical value. If `TRUE` (the default), metadata is preserved. Ignored if `x` is a matrix.}
}
\value{
If `x` is an `ena.set`, it returns the modified `ena.set` with the centered data stored in `x$model$points.for.projection`. If `x` is a matrix, it returns a centered matrix.
}
\description{
This function centers the line weights of an `ena.set` by subtracting the mean of each connection from all units. This is a standard step in preparing data for rotation.
}
\examples{
data(RS.data)

codes <- c("Data", "Technical.Constraints", "Performance.Parameters",
           "Client.and.Consultant.Requests", "Design.Reasoning",
           "Collaboration")
units <- c("Condition", "UserName")
horizon <- c("Condition", "GroupName")
enaset <- RS.data |>
  accumulate(units, codes, horizon) |>
  sphere_norm() |>
  center()
}
