% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qedata_define.R
\name{horizon}
\alias{horizon}
\title{Reclassify specified columns as horizon or list horizon columns in a data.table}
\usage{
horizon(x, ...)
}
\arguments{
\item{x}{A data.table. The data.table containing the columns to be reclassified or checked.}

\item{...}{Additional arguments specifying the names of the columns to be reclassified.}
}
\value{
The modified data.table with specified columns reclassified as 'qe.horizon', or a character vector of column names already classified as 'qe.horizon'.
}
\description{
This function reclassifies specified columns of a data.table to the 'qe.horizon' format if column names are provided.
If no column names are provided, it returns the names of columns that are already classified as 'qe.horizon'.
}
\examples{
library(data.table)
dt <- data.table(a = 1:5, b = 6:10)
# Reclassify columns 'a' and 'b' as 'qe.horizon'
dt <- horizon(dt, "a", "b")
# List columns classified as 'qe.horizon'
horizon_columns <- horizon(dt)
}
