% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{transform_parameters_spacetime}
\alias{transform_parameters_spacetime}
\title{Transform Spacetime SPDE Model Parameters to Original Scale}
\usage{
transform_parameters_spacetime(theta, st_model)
}
\arguments{
\item{theta}{A numeric vector containing the transformed parameters in this order:
\describe{
\item{lkappa}{The logarithmic representation of kappa.}
\item{lsigma}{The logarithmic representation of sigma.}
\item{lgamma}{The logarithmic representation of gamma.}
\item{logit_rho (optional)}{The logit-transformed representation of rho, if drift = 1.}
\item{logit_rho2 (optional)}{The logit-transformed representation of rho2, if drift = 1 and d = 2.}
}}

\item{st_model}{A list containing the spacetime model parameters:
\describe{
\item{d}{The dimension (e.g., 1 or 2).}
\item{bound}{The bound for rho and rho2.}
\item{is_bounded}{A logical value indicating if rho and rho2 are bounded.}
\item{drift}{A logical value indicating if drift is included in the model.}
}}
}
\value{
A named list with the parameters in the original scale:
\describe{
\item{kappa}{The original scale for kappa (exponential of lkappa).}
\item{sigma}{The original scale for sigma (exponential of lsigma).}
\item{gamma}{The original scale for gamma (exponential of lgamma).}
\item{rho (optional)}{The original scale for rho.}
\item{rho2 (optional)}{The original scale for rho2, if d = 2.}
}
}
\description{
This function takes a vector of transformed parameters and applies the appropriate
transformations to return them in the original scale for use in spacetime SPDE models.
}
