% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.sim_data.R
\name{update.sim_data}
\alias{update.sim_data}
\title{Update \code{sim_data} Object}
\usage{
\method{update}{sim_data}(object, ..., evaluate = TRUE)
}
\arguments{
\item{object}{\code{sim_data} object; returned by \code{\link{initialise}} function}

\item{...}{further arguments passed to or from other methods;
currently none specified}

\item{evaluate}{logical vector of length 1; if \code{TRUE} evaluates the new call, otherwise
returns the call}
}
\value{
If \code{evaluate = TRUE} then the updated \code{sim_data} object,
otherwise the updated call.
}
\description{
This function updates a \code{sim_data} object.
}
\examples{
\donttest{

# data preparation
library(terra)
n1_small <- rast(system.file("input_maps/n1_small.tif", package = "rangr"))
K_small <- rast(system.file("input_maps/K_small.tif", package = "rangr"))

sim_data_1 <- initialise(
  n1_map = n1_small,
  K_map = K_small,
  r = log(2),
  rate = 1 / 1e3
)
summary(sim_data_1)

sim_data_2 <- update(sim_data_1, max_dist = 3000)
summary(sim_data_2)

}

}
