% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class005-subject.R
\name{new_rave_subject}
\alias{new_rave_subject}
\alias{as_rave_subject}
\alias{has_rave_subject}
\title{Get \code{\link{RAVESubject}} instance from character}
\usage{
new_rave_subject(project_name, subject_code, strict = TRUE)

as_rave_subject(subject_id, strict = TRUE, reload = TRUE)

has_rave_subject(subject_id)
}
\arguments{
\item{project_name}{character of 'RAVE' project name}

\item{subject_code}{character of 'RAVE' subject code}

\item{strict}{whether to check if subject directories exist or not}

\item{subject_id}{character in format \code{"project/subject"}}

\item{reload}{whether to reload (update) subject information, default is true}
}
\value{
\code{\link{RAVESubject}} instance
}
\description{
Get \code{\link{RAVESubject}} instance from character
}
\examples{

subject <- new_rave_subject(project_name = "demo@bids:ds04001",
                            subject_code = "DemoSubject",
                            strict = FALSE)

subject

subject$project$path
subject$imaging_path

}
\seealso{
\code{\link{RAVESubject}}
}
