% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow-ANTs_ct_mri_coregistration.R
\name{cmd_run_ants_coreg}
\alias{cmd_run_ants_coreg}
\alias{ants_coreg}
\title{Register a computerized tomography (CT) image to MRI via 'ANTs'}
\usage{
ants_coreg(
  ct_path,
  mri_path,
  coreg_path = NULL,
  reg_type = c("DenseRigid", "Rigid", "SyN", "Affine", "TRSAA", "SyNCC", "SyNOnly"),
  aff_metric = c("mattes", "meansquares", "GC"),
  syn_metric = c("mattes", "meansquares", "demons", "CC"),
  verbose = TRUE,
  ...
)

cmd_run_ants_coreg(
  subject,
  ct_path,
  mri_path,
  reg_type = c("DenseRigid", "Rigid", "SyN", "Affine", "TRSAA", "SyNCC", "SyNOnly"),
  aff_metric = c("mattes", "meansquares", "GC"),
  syn_metric = c("mattes", "meansquares", "demons", "CC"),
  verbose = TRUE,
  dry_run = FALSE
)
}
\arguments{
\item{ct_path, mri_path}{absolute paths to 'CT' and 'MR' image files}

\item{coreg_path}{registration path, where to save results; default is
the parent folder of \code{ct_path}}

\item{reg_type}{registration type, choices are \code{'DenseRigid'},
\code{'Rigid'}, \code{'Affine'}, \code{'SyN'}, \code{'TRSAA'},
\code{'SyNCC'}, \code{'SyNOnly'}, or other types; see
\code{\link[rpyANTs]{ants_registration}}}

\item{aff_metric}{cost function to use for linear or 'affine' transform}

\item{syn_metric}{cost function to use for \code{'SyN'} transform}

\item{verbose}{whether to verbose command; default is true}

\item{...}{passed to \code{\link[rpyANTs]{ants_registration}}}

\item{subject}{'RAVE' subject}

\item{dry_run}{whether to dry-run the script and to print out the command
instead of executing the code; default is false}
}
\value{
Aligned 'CT' will be generated at the \code{coreg_path} path:
\describe{
\item{\code{'ct_in_t1.nii.gz'}}{aligned 'CT' image; the image is
also re-sampled into 'MRI' space}
\item{\code{'transform.yaml'}}{transform settings and outputs}
\item{\code{'CT_IJK_to_MR_RAS.txt'}}{transform matrix from volume 'IJK'
space in the original 'CT' to the 'RAS' anatomical coordinate in 'MR'
scanner; 'affine' transforms only}
\item{\code{'CT_RAS_to_MR_RAS.txt'}}{transform matrix from scanner 'RAS'
space in the original 'CT' to 'RAS' in 'MR' scanner space; 'affine'
transforms only}
}
}
\description{
Please avoid calling \code{ants_coreg} directly; use
\code{cmd_run_ants_coreg} for more robust behaviors
}
