% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim_dist_to_black.R
\name{optim_dist_to_black}
\alias{optim_dist_to_black}
\title{Optimize minimum distance to black pixels}
\usage{
optim_dist_to_black(r, z, a, m, bin, g)
}
\arguments{
\item{r}{numeric \link[terra:SpatRaster-class]{terra::SpatRaster} of one layer. Typically the blue
band of a canopy image.}

\item{z}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=zenith_image]{zenith_image()}}.}

\item{a}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=azimuth_image]{azimuth_image()}}.}

\item{m}{logical \link[terra:SpatRaster-class]{terra::SpatRaster} with one layer. A binary mask with
\code{TRUE} for selected pixels.}

\item{bin}{logical \link[terra:SpatRaster-class]{terra::SpatRaster} of one layer. Binary image where
\code{TRUE} marks candidate sky pixels. Typically the output of
\code{\link[=binarize_with_thr]{binarize_with_thr()}}.}

\item{g}{numeric \link[terra:SpatRaster-class]{terra::SpatRaster} of one layer. Segmentation grid,
usually built with \code{\link[=sky_grid_segmentation]{sky_grid_segmentation()}} or \code{\link[=chessboard]{chessboard()}}. Ignored
when \code{method = "local_max"}.}
}
\value{
numeric vector of length one to be passed as \code{dist_to_black} to
\code{\link[=extract_sky_points]{extract_sky_points()}}, or \code{NULL} if no buffer is advised.
}
\description{
Estimate an optimal buffer (\code{dist_to_black}) to keep sampled sky points away
from candidate canopy pixels (black pixels).
}
\details{
The heuristic seeks the largest buffer that still yields uniform angular
coverage. It iteratively decreases \code{dist_to_black} while monitoring the
percentage of 30 deg sky‑grid cells covered by sampled points. If coverage
is low, the buffer is relaxed (and may be removed). This balances border
avoidance with representativeness across the sky vault.
}
\examples{
\dontrun{
caim <- read_caim()
z <- zenith_image(ncol(caim), lens())
a <- azimuth_image(z)
m <- !is.na(z)
r <- caim$Blue

bin <- binarize_by_region(r, ring_segmentation(z, 15), "thr_isodata") &
  select_sky_region(z, 0, 88)
g <- sky_grid_segmentation(z, a, 10, first_ring_different = TRUE)

dist_to_black <- optim_dist_to_black(r, z, a, m, bin, g)
dist_to_black

bin <- grow_black(bin, 11)
plot(bin)
dist_to_black <- optim_dist_to_black(r, z, a, m, bin, g)
dist_to_black
}
}
