% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_sky_region.R
\name{select_sky_region}
\alias{select_sky_region}
\title{Select sky region}
\usage{
select_sky_region(r, from, to)
}
\arguments{
\item{r}{single-layer \link[terra:SpatRaster-class]{terra::SpatRaster}, typically from
\code{\link[=zenith_image]{zenith_image()}} or \code{\link[=azimuth_image]{azimuth_image()}}.}

\item{from, to}{numeric vectors of length one. Angles in deg, inclusive limits.}
}
\value{
Logical \link[terra:SpatRaster-class]{terra::SpatRaster} (\code{TRUE} for the selected region) of
the same dimensions as \code{r}.
}
\description{
Select pixels from a single-layer image based on value limits.
}
\details{
Works with any numeric \link[terra:SpatRaster-class]{terra::SpatRaster} of one layer, but is
especially well-suited for images from \code{\link[=zenith_image]{zenith_image()}} or
\code{\link[=azimuth_image]{azimuth_image()}}. For azimuth ranges that wrap around 0 deg, combine two
masks with logical OR.
}
\examples{
\dontrun{
z <- zenith_image(1000, lens())
a <- azimuth_image(z)
m1 <- select_sky_region(z, 20, 70)
plot(m1)
m2 <- select_sky_region(a, 330, 360)
plot(m2)
plot(m1 & m2)
plot(m1 | m2)

# 15 deg on each side of 0
m1 <- select_sky_region(a, 0, 15)
m2 <- select_sky_region(a, 345, 360)
plot(m1 | m2)

# You can use this
plot(!is.na(z))
# instead of this
plot(select_sky_region(z, 0, 90))
}
}
\seealso{
\code{\link[=paint_with_mask]{paint_with_mask()}}
}
