% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{corr}
\alias{corr}
\title{Compute the structural correlogram of the CLSP constraint system.}
\usage{
corr(object, reset = FALSE, threshold = 0)
}
\arguments{
\item{object}{An object of class \code{"clsp"}.}

\item{reset}{Logical, default = \code{FALSE}.
If \code{TRUE}, forces recomputation of all diagnostic values.}

\item{threshold}{Numeric, default = \code{0}.
If positive, limits the output to constraints with
\eqn{\mathrm{RMSA}_i \ge \text{threshold}}.}
}
\value{
A named list containing per-row diagnostic values:
\describe{
\item{constraint}{Vector of constraint indices (1-based).}
\item{rmsa_i}{List of \eqn{\mathrm{RMSA}_i} values.}
\item{rmsa_dkappaC}{List of \eqn{\Delta\kappa(C)} after deleting row i.}
\item{rmsa_dkappaB}{List of \eqn{\Delta\kappa(B)} after deleting row i.}
\item{rmsa_dkappaA}{List of \eqn{\Delta\kappa(A)} after deleting row i.}
\item{rmsa_dnrmse}{List of \eqn{\Delta\mathrm{NRMSE}} after deleting row i.}
\item{rmsa_dzhat}{List of \eqn{\Delta\hat{z}} after deleting row i.}
\item{rmsa_dz}{List of \eqn{\Delta z} after deleting row i.}
\item{rmsa_dx}{List of \eqn{\Delta x} after deleting row i.}
}
}
\description{
This method performs a row-deletion sensitivity analysis on the canonical
constraint matrix \eqn{[C | S]}, denoted as \eqn{C_{\text{canon}}}, and
evaluates the marginal effect of each constraint row on numerical stability,
angular alignment, and estimator sensitivity.
}
\details{
For each row \eqn{i} in \eqn{C_{\text{canon}}}, it computes:
\itemize{
\item The Root Mean Square Alignment (\eqn{\mathrm{RMSA}_i}) with all
other rows \eqn{j \ne i}.
\item The change in condition numbers \eqn{\kappa(C)}, \eqn{\kappa(B)}, and
\eqn{\kappa(A)} when row \eqn{i} is deleted.
\item The effect on estimation quality: changes in NRMSE, \eqn{\hat{z}},
\eqn{z}, and \eqn{x}.
}

Additionally, it computes the total RMSA statistic across all rows,
summarizing the overall angular alignment of the constraint block.
}
