% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_to_gitignore.R
\name{add_to_gitignore}
\alias{add_to_gitignore}
\title{Add to the .gitignore file}
\usage{
add_to_gitignore(x, open = FALSE, quiet = FALSE)
}
\arguments{
\item{x}{A character vector. One or several files/folders names to be added
to the \code{.gitignore}.}

\item{open}{A logical value. If \code{TRUE} the \code{.gitignore} file is opened in
the editor. Default is \code{FALSE}.}

\item{quiet}{A logical value. If \code{TRUE} messages are deleted. Default is
\code{FALSE}.}
}
\value{
No return value.
}
\description{
This function creates a \code{.gitignore} file at the root of the project based on
a template (specific to R). If a \code{.gitignore} is already present, files to
be untracked by \strong{git} are just added to this file.
}
\examples{
\dontrun{
add_to_gitignore(open = TRUE)
add_to_gitignore(".DS_Store")
}
}
\seealso{
Other development functions: 
\code{\link{add_dependencies}()},
\code{\link{add_github_actions_check}()},
\code{\link{add_github_actions_citation}()},
\code{\link{add_github_actions_codecov}()},
\code{\link{add_github_actions_codemeta}()},
\code{\link{add_github_actions_document}()},
\code{\link{add_github_actions_pkgdown}()},
\code{\link{add_github_actions_render}()},
\code{\link{add_r_depend}()},
\code{\link{add_to_buildignore}()}
}
\concept{development functions}
