% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abort-bad-argument.R
\name{abort_bad_argument}
\alias{abort_bad_argument}
\title{Send an error message for an unexpected argument input}
\usage{
abort_bad_argument(
  arg,
  must = NULL,
  not = NULL,
  footer = NULL,
  custom = NULL,
  call = rlang::caller_env()
)
}
\arguments{
\item{arg}{The name of the argument.}

\item{must}{The requirement for input values that is not met.}

\item{not}{The current state of \code{argument} that is problematic.}

\item{footer}{Additional text to add to the error message.}

\item{custom}{A custom error message to override the default message of
\code{must} + \code{not}.}

\item{call}{The call stack.}
}
\value{
An error message created by \code{\link[cli:cli_abort]{cli::cli_abort()}}.
}
\description{
Send an error message for an unexpected argument input
}
\examples{
try(abort_bad_argument(arg = "my_arg", must = "be a character vector"))
}
