% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_ms.R
\name{process_ms}
\alias{process_ms}
\title{Process MS-like omics data}
\usage{
process_ms(
  X,
  remove_ids = NULL,
  min_prev = 0.8,
  rename_feat = TRUE,
  transform = c("none", "log", "sqrt"),
  log_base_num = 10,
  impute = c("none", "min_val", "QRILC"),
  min_val_factor = 1,
  platform = c("ms", "nmr"),
  seed = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{X}{A numeric data frame or matrix (samples in rows, features in columns).}

\item{remove_ids}{A regex or character vector to filter out rows in \code{X} (e.g. QCs).
Set to \code{NULL} to skip.}

\item{min_prev}{Numeric between 0 and 1. Minimum non-missing prevalence threshold.
Zeros are first converted to NA.}

\item{rename_feat}{Logical. If \code{TRUE}, features will be renamed as "feat_n"
and original labels stored.}

\item{transform}{One of \code{"none"}, \code{"log"}, or \code{"sqrt"}.}

\item{log_base_num}{Numeric logarithm base. Required if \code{transform = "log"}.}

\item{impute}{One of \code{"none"}, \code{"min_val"}, or \code{"QRILC"}.
Note: \code{imputeLCMD::impute.QRILC()} requires log-transformed data.
Log-transform will be forced internally regardless of \verb{transform = } setting.}

\item{min_val_factor}{Numeric >= 1. Scaling factor for min value imputation.}

\item{platform}{whether data was generated by mass spectrometry (\code{"ms"}) or
nuclear magnetic resonance spectroscopy (\code{"nmr"}), the latter allowing negative
values in the matrix.}

\item{seed}{Optional integer. If provided, sets the random seed for reproducible
\code{imputeLCMD::imputeQRILC()} permutation results.}

\item{verbose}{Logical. Show messages about the processing steps.}

\item{...}{Extra arguments passed to \code{imputeLCMD::impute.QRILC()}.}
}
\value{
A list:
\describe{
\item{X_names}{Feature mapping original vs. new names.}
\item{X_processed}{Processed numeric matrix.}
}
}
\description{
This function performs common preprocessing steps for mass spectrometry (MS)-like
omics datasets, including QC sample removal, zero-to-NA conversion, feature
prevalence filtering, transformation, and feature-wise value imputation.
}
\examples{
X <- matrix(sample(c(0:10), size = 80, replace = TRUE),
            nrow = 20, ncol = 4,
            dimnames = list(paste0("sample", 1:20),
                            paste0("feat", 1:4)))

result <- process_ms(X, verbose = FALSE) # Generates NA warning

}
\references{
Lazar, C., Gatto, L., Ferro, M., Bruley, C., & Burger, T. (2016).
Accounting for the multiple natures of missing values in label-free quantitative
proteomics data sets to compare imputation strategies.
\emph{Journal of Proteome Research}, 15(4), 1116–1125. \doi{10.1021/acs.jproteome.5b00981}

Wei, R., Wang, J., Su, M., Jia, E., Chen, S., Chen, T., & Ni, Y. (2018).
Missing value imputation approach for mass spectrometry-based metabolomics data.
\emph{Scientific Reports}, 8, 663. \doi{10.1038/s41598-017-19120-0}
}
\seealso{
\code{\link[imputeLCMD:impute.QRILC]{imputeLCMD::impute.QRILC()}} for imputing missing values.
}
