% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rehh.R
\docType{package}
\name{rehh-package}
\alias{rehh}
\alias{rehh-package}
\title{rehh: Searching for Footprints of Selection using 'Extended Haplotype Homozygosity' Based Tests}
\description{
Population genetic data such as 'Single Nucleotide Polymorphisms' (SNPs) is often used to identify genomic regions that have been under recent natural or artificial selection and might provide clues about the molecular mechanisms of adaptation. One approach, the concept of an 'Extended Haplotype Homozygosity' (EHH), introduced by (Sabeti 2002) \doi{10.1038/nature01140}, has given rise to several statistics designed for whole genome scans. The package provides functions to compute three of these, namely: 'iHS' (Voight 2006) \doi{10.1371/journal.pbio.0040072} for detecting positive or 'Darwinian' selection within a single population as well as 'Rsb' (Tang 2007) \doi{10.1371/journal.pbio.0050171} and 'XP-EHH' (Sabeti 2007) \doi{10.1038/nature06250}, targeted at differential selection between two populations. Various plotting functions are included to facilitate visualization and interpretation of these statistics.
}
\details{
See \code{vignette("rehh", package = "rehh")} for an overview of the package and
\code{vignette("examples", package = "rehh")} for a more detailed discussion of two small example
data sets.
}
\references{
Gautier, M. and Naves, M. (2011). Footprints of selection in the ancestral admixture of a New World Creole cattle breed. \emph{Molecular Ecology}, \strong{20}, 3128-3143.

Gautier M. and Vitalis R. (2012). rehh: An R package to detect footprints of selection in
genome-wide SNP data from haplotype structure. \emph{Bioinformatics}, \strong{28}(8), 1176-1177.

Gautier M., Klassmann A., and Vitalis R. (2017). rehh 2.0: a reimplementation of the R package
rehh to detect positive selection from haplotype structure. \emph{Molecular Ecology Resources}, \strong{17}, 78-90.

Klassmann, A. and Gautier, M. (2022). Detecting selection using extended haplotype homozygosity (EHH)-based statistics in unphased or unpolarized data. \emph{PLoS One}. \strong{17}(1):e0262024
\doi{10.1371/journal.pone.0262024}

Sabeti, P.C. et al. (2002). Detecting recent positive selection in the human genome from haplotype structure. \emph{Nature}, \strong{419}, 832-837.

Sabeti, P.C. et al. (2007). Genome-wide detection and characterization of positive selection in human populations. \emph{Nature}, \strong{449}, 913-918.

Tang, K. and Thornton, K.R. and Stoneking, M. (2007). A New Approach for Using Genome Scans to Detect Recent Positive Selection in the Human Genome. \emph{Plos Biology}, \strong{7}, e171.

Voight, B.F. and Kudaravalli, S. and Wen, X. and Pritchard, J.K. (2006). A map of recent positive selection in the human genome. \emph{Plos Biology}, \strong{4}, e72.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://CRAN.R-project.org/package=rehh}
  \item \url{https://gitlab.com/oneoverx/rehh}
  \item Report bugs at \url{https://gitlab.com/oneoverx/rehh/-/issues}
}

}
\author{
\strong{Maintainer}: Alexander Klassmann \email{rehh@oneoverx.eu}

Authors:
\itemize{
  \item Mathieu Gautier \email{mathieu.gautier@inrae.fr}
  \item Renaud Vitalis
}

}
