% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_mad.R
\name{scale_mad}
\alias{scale_mad}
\title{Standardize based on the absolute median deviation}
\usage{
scale_mad(x)
}
\arguments{
\item{x}{The vector to be scaled.}
}
\value{
A numeric vector of standardized data.
}
\description{
Scale and center ("standardize") data based on
the median absolute deviation (MAD).
}
\details{
The function subtracts the median to each observation, and then
divides the outcome by the MAD. This is analogous to regular standardization
which subtracts the mean to each observaion, and then divides the outcome
by the standard deviation.

For the \emph{easystats} equivalent, use:
\code{datawizard::standardize(x, robust = TRUE)}.
}
\examples{
scale_mad(mtcars$mpg)
}
\references{
Leys, C., Ley, C., Klein, O., Bernard, P., & Licata, L.
(2013). Detecting outliers: Do not use standard deviation
around the mean, use absolute deviation around the median.
\emph{Journal of Experimental Social Psychology}, \emph{49}(4), 764–766.
https://doi.org/10.1016/j.jesp.2013.03.013
}
\keyword{MAD}
\keyword{mean}
\keyword{median}
\keyword{normalization}
\keyword{outliers}
\keyword{standardization}
