% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{.addTagsRepo}
\alias{.addTagsRepo}
\alias{.updateTagsRepo}
\title{Add a Tag to a Cached Object in the Repository}
\usage{
.addTagsRepo(
  cacheId,
  cachePath = getOption("reproducible.cachePath"),
  tagKey = character(),
  tagValue = character(),
  cacheSaveFormat = getOption("reproducible.cacheSaveFormat"),
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL)
)

.updateTagsRepo(
  cacheId,
  cachePath = getOption("reproducible.cachePath"),
  tagKey = character(),
  tagValue = character(),
  add = TRUE,
  cacheSaveFormat = getOption("reproducible.cacheSaveFormat"),
  drv = getDrv(getOption("reproducible.drv", NULL)),
  conn = getOption("reproducible.conn", NULL)
)
}
\arguments{
\item{cacheId}{\code{character(1)}
Unique identifier of the cached object. Must be of length 1.}

\item{cachePath}{\code{character(1)}
Path to the cache directory. Defaults to \code{getOption("reproducible.cachePath")}.}

\item{tagKey}{\code{character(1)}
The key for the tag. Must be supplied.}

\item{tagValue}{\code{character(1)}
The new value for the tag. Must be supplied.}

\item{cacheSaveFormat}{\code{character(1)}
Format used for saving cache files. Defaults to \code{getOption("reproducible.cacheSaveFormat")}.}

\item{drv}{A DBI driver object. Defaults to \code{getDrv(getOption("reproducible.drv", NULL))}.}

\item{conn}{A DBI connection object. If \code{NULL}, a new connection is created internally.}

\item{add}{\code{logical(1)}
If \code{TRUE}, adds the tag if it does not exist. Defaults to \code{TRUE}.}
}
\value{
\code{NULL} (invisibly). The function is called for its side effects.

\code{NULL} (invisibly). Called for its side effects.
}
\description{
This hidden function appends a single tag (key-value pair) to the metadata
of a cached object identified by its \code{cacheId}. Tags can be stored either in
a database (via DBI) or in a file-based cache system.

Updates the value of an existing tag for a cached object identified by its
\code{cacheId}. If the tag does not exist and \code{add = TRUE}, the tag will be added.
This function supports both database-backed and file-based cache systems.
}
\details{
This function is primarily used internally by the \code{reproducible} package to
maintain metadata about cached objects. It supports both database-backed and
file-based caching systems.

\itemize{
\item If \code{useDBI()} returns \code{TRUE}, the tag update is performed in the database table.
\item If no rows are affected and \code{add = TRUE}, the tag is inserted using \code{.addTagsRepo()}.
\item For file-based caches, the function modifies the tag in the corresponding metadata file.
}
}
\examples{
\dontrun{
a <- Cache(rnorm(1))
.addTagsRepo(cacheId = gsub("cacheId:", "", attr(a, "tags")),
             tagKey = "status", tagValue = "processed")
showCache() # last entry is the above line
}

\dontrun{
a <- Cache(rnorm(1))
# Update an existing tag
.updateTagsRepo(cacheId = gsub("cacheId:", "", attr(a, "tags")),
             tagKey = "status", tagValue = "second")

# Add a tag if it doesn't exist
.updateTagsRepo(cacheId = gsub("cacheId:", "", attr(a, "tags")),
             tagKey = "status", tagValue = "new", add = TRUE)
}

}
\seealso{
\code{\link[=.addTagsRepo]{.addTagsRepo()}} for adding tags without updating.
}
