% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chek_reptiledb_status.R
\name{get_latest_reptile_download}
\alias{get_latest_reptile_download}
\title{Get Latest Reptile Database Download Information}
\usage{
get_latest_reptile_download(
  base_url = "http://www.reptile-database.org/data/",
  current_year = as.integer(format(Sys.Date(), "\%Y")),
  file_types = c("xlsx", "xls", "zip"),
  return_info = FALSE
)
}
\arguments{
\item{base_url}{Character. The base URL of the data page.
Default: "http://www.reptile-database.org/data/"}

\item{current_year}{Numeric. Year to prioritize in search.
Default: current system year}

\item{file_types}{Character vector. File extensions to search for.
Default: c("xlsx", "xls", "zip")}

\item{return_info}{Logical. If TRUE, returns detailed information list.
If FALSE, returns only the URL string. Default: FALSE}
}
\value{
If \code{return_info = FALSE}: Character string with the download URL, or NULL

If \code{return_info = TRUE}: A list with:
\describe{
\item{url}{Complete download URL}
\item{filename}{File name}
\item{file_type}{File extension}
\item{checked_at}{Timestamp of check}
\item{source_page}{Source webpage URL}
}
}
\description{
Retrieves information about the most recent reptile database file
available for download from the official website.
}
\examples{
\donttest{
# Get download URL
url <- get_latest_reptile_download()

# Get detailed information
info <- get_latest_reptile_download(return_info = TRUE)
}

}
