% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_prob_prob.R
\name{comp_NPV}
\alias{comp_NPV}
\title{Compute a decision's negative predictive value (NPV) from probabilities.}
\usage{
comp_NPV(prev, sens, spec)
}
\arguments{
\item{prev}{The condition's prevalence \code{\link{prev}}
(i.e., the probability of condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).}

\item{spec}{The decision's specificity value \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is \code{FALSE}).}
}
\value{
The negative predictive value \code{\link{NPV}} as a probability.
A warning is provided for NaN values.
}
\description{
\code{comp_NPV} computes the negative predictive value \code{\link{NPV}}
from 3 essential probabilities
\code{\link{prev}}, \code{\link{sens}}, and \code{\link{spec}}.
}
\details{
\code{comp_NPV} uses probabilities (not frequencies)
and does not round results.
}
\examples{
# (1) Ways to work:
comp_NPV(.50, .500, .500)  # => NPV = 0.5
comp_NPV(.50, .333, .666)  # => NPV = 0.4996

# (2) Watch out for vectors:
prev <- seq(0, 1, .1)
comp_NPV(prev, .5, .5)  # => without NaN values
comp_NPV(prev,  1,  0)  # => with NaN values

# (3) Watch out for extreme values:
comp_NPV(1, 1, 1)   # => NaN, as cr = 0 and mi = 0: 0/0
comp_NPV(1, 1, 0)   # => NaN, as cr = 0 and mi = 0: 0/0
comp_NPV(.5, sens = 1, spec = 0)  # => NaN, no dec_neg cases:  NPV = 0/0 = NaN
is_extreme_prob_set(.5, sens = 1, spec = 0)  # => verifies extreme cases

}
\seealso{
\code{\link{comp_spec}} and \code{\link{comp_PPV}} compute related probabilities;
\code{\link{is_extreme_prob_set}} verifies extreme cases;
\code{\link{comp_complement}} computes a probability's complement;
\code{\link{is_complement}} verifies probability complements;
\code{\link{comp_prob}} computes current probability information;
\code{\link{prob}} contains current probability information;
\code{\link{is_prob}} verifies probabilities.

Other functions computing probabilities: 
\code{\link{comp_FDR}()},
\code{\link{comp_FOR}()},
\code{\link{comp_PPV}()},
\code{\link{comp_acc}()},
\code{\link{comp_accu_freq}()},
\code{\link{comp_accu_prob}()},
\code{\link{comp_comp_pair}()},
\code{\link{comp_complement}()},
\code{\link{comp_complete_prob_set}()},
\code{\link{comp_err}()},
\code{\link{comp_fart}()},
\code{\link{comp_mirt}()},
\code{\link{comp_ppod}()},
\code{\link{comp_prob}()},
\code{\link{comp_prob_freq}()},
\code{\link{comp_sens}()},
\code{\link{comp_spec}()}
}
\concept{functions computing probabilities}
