% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_util.R
\name{is_integer}
\alias{is_integer}
\title{Test for inters (i.e., whole numbers).}
\usage{
is_integer(x, tol = .Machine$double.eps^0.5)
}
\arguments{
\item{x}{Number(s) to test (required, accepts numeric vectors).}

\item{tol}{Numeric tolerance value.
Default: \code{tol = .Machine$double.eps^0.5}
(see \code{?.Machine} for details).}
}
\description{
\code{is_integer} tests if \code{x} contains \emph{only} integer numbers.
}
\details{
Thus, \code{is_integer} does what the \strong{base} R function \code{is.integer} is \emph{not} designed to do:

\itemize{
  \item \code{is_integer()} returns TRUE or FALSE depending on whether its numeric argument \code{x} is an integer value (i.e., a "whole" number).

  \item \code{is.integer()} returns TRUE or FALSE depending on whether its argument is of type "integer", and FALSE if its argument is a factor.
}

See the documentation of \code{\link{is.integer}} for definition and details.
}
\examples{
is_integer(2)    # TRUE
is_integer(2/1)  # TRUE
is_integer(2/3)  # FALSE
x <- seq(1, 2, by = 0.5)
is_integer(x)

# Note contrast to base R:
is.integer(2/1)  # FALSE!

# Compare:
is.integer(1 + 2)
is_integer(1 + 2)

}
\seealso{
\code{\link{is.integer}} function of the R \strong{base} package.

Other verification functions: 
\code{\link{is_complement}()},
\code{\link{is_extreme_prob_set}()},
\code{\link{is_freq}()},
\code{\link{is_matrix}()},
\code{\link{is_perc}()},
\code{\link{is_prob}()},
\code{\link{is_suff_prob_set}()},
\code{\link{is_valid_prob_pair}()},
\code{\link{is_valid_prob_set}()},
\code{\link{is_valid_prob_triple}()}
}
\concept{verification functions}
