# This file was generated by the {rix} R package v0.15.0 on 2025-02-13
# with following call:
# >rix(date = "2025-02-10",
#  > r_pkgs = NULL,
#  > system_pkgs = NULL,
#  > git_pkgs = list(package_name = "rixTest",
#  > repo_url = "https://github.com/mihem/rixTest",
#  > commit = "e2fc06592877bde459855364f9e7115e0cd6d409"),
#  > ide = "none",
#  > project_path = ".",
#  > overwrite = TRUE,
#  > print = TRUE,
#  > r_ver = "4.4.2")
# It uses the `rstats-on-nix` fork of `nixpkgs` which provides improved
# compatibility with older R versions and R packages for Linux/WSL and
# Apple Silicon computers.
# Report any issues to https://github.com/ropensci/rix
let
 pkgs = import (fetchTarball "https://github.com/rstats-on-nix/nixpkgs/archive/2025-02-10.tar.gz") {};
  
    rix = (pkgs.rPackages.buildRPackage {
      name = "rix";
      src = pkgs.fetchgit {
        url = "https://github.com/ropensci/rix";
        rev = "88bb24f";
        sha256 = "sha256-zIaGjHvgEiDkBBu8hfRSFnZvtq3qH75uTug9Qcqn+iQ=";
      };
      propagatedBuildInputs = builtins.attrValues {
        inherit (pkgs.rPackages) 
          codetools
          curl
          jsonlite
          sys;
      };
    });

    rixTest = (pkgs.rPackages.buildRPackage {
      name = "rixTest";
      src = pkgs.fetchgit {
        url = "https://github.com/mihem/rixTest";
        rev = "e2fc06592877bde459855364f9e7115e0cd6d409";
        sha256 = "sha256-enFNI3+dH7JpGj2QkDmJuJZuKJyGXTE/vb1FvcQ7fRw=";
      };
      propagatedBuildInputs = builtins.attrValues {
        inherit (pkgs.rPackages) ;
      } ++ [ rix ];
    });
    
  system_packages = builtins.attrValues {
    inherit (pkgs) 
      glibcLocales
      nix
      R;
  };
  
in

pkgs.mkShell {
  LOCALE_ARCHIVE = if pkgs.stdenv.hostPlatform.system == "x86_64-linux" then "${pkgs.glibcLocales}/lib/locale/locale-archive" else "";
  LANG = "en_US.UTF-8";
   LC_ALL = "en_US.UTF-8";
   LC_TIME = "en_US.UTF-8";
   LC_MONETARY = "en_US.UTF-8";
   LC_PAPER = "en_US.UTF-8";
   LC_MEASUREMENT = "en_US.UTF-8";

  buildInputs = [ rixTest   system_packages   ];
  
}
