/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.extractors;

import jdplus.sa.base.core.diagnostics.CombinedSeasonalityTests;
import jdplus.sa.base.core.tests.CombinedSeasonality;
import jdplus.toolkit.base.api.information.InformationMapping;
import jdplus.toolkit.base.api.stats.OneWayAnova;
import jdplus.toolkit.base.core.stats.tests.TestsUtility;

public class CombinedSeasonalityTestsExtractor
extends InformationMapping<CombinedSeasonalityTests> {
    public Class getSourceClass() {
        return CombinedSeasonalityTests.class;
    }

    public CombinedSeasonalityTestsExtractor() {
        this.set("seas-lin-combined", String.class, source -> {
            CombinedSeasonality satest = source.linearizedTest();
            if (satest == null) {
                return null;
            }
            return satest.getSummary().name();
        });
        this.set("seas-lin-evolutive", Double.class, source -> {
            CombinedSeasonality satest = source.linearizedTest();
            if (satest == null) {
                return null;
            }
            return TestsUtility.ofAnova((OneWayAnova)satest.getEvolutiveSeasonalityTest()).getPvalue();
        });
        this.set("seas-lin-stable", Double.class, source -> {
            CombinedSeasonality satest = source.linearizedTest();
            if (satest == null) {
                return null;
            }
            return TestsUtility.ofAnova((OneWayAnova)satest.getStableSeasonalityTest()).getPvalue();
        });
        this.set("seas-si-combined", String.class, source -> {
            CombinedSeasonality sitest = source.siTest(false);
            if (sitest == null) {
                return null;
            }
            return sitest.getSummary().name();
        });
        this.set("seas-si-combined3", String.class, source -> {
            CombinedSeasonality sitest = source.siTest(true);
            if (sitest == null) {
                return null;
            }
            return sitest.getSummary().name();
        });
        this.set("seas-si-evolutive", Double.class, source -> {
            CombinedSeasonality sitest = source.siTest(false);
            if (sitest == null) {
                return null;
            }
            return TestsUtility.ofAnova((OneWayAnova)sitest.getEvolutiveSeasonalityTest()).getPvalue();
        });
        this.set("seas-si-stable", Double.class, source -> {
            CombinedSeasonality sitest = source.siTest(false);
            if (sitest == null) {
                return null;
            }
            return TestsUtility.ofAnova((OneWayAnova)sitest.getStableSeasonalityTest()).getPvalue();
        });
        this.set("seas-res-combined", String.class, source -> {
            CombinedSeasonality rtest = source.residualsTest(false);
            if (rtest == null) {
                return null;
            }
            return rtest.getSummary().name();
        });
        this.set("seas-res-combined3", String.class, source -> {
            CombinedSeasonality rtest = source.residualsTest(true);
            if (rtest == null) {
                return null;
            }
            return rtest.getSummary().name();
        });
        this.set("seas-res-evolutive", Double.class, source -> {
            CombinedSeasonality rtest = source.residualsTest(false);
            if (rtest == null) {
                return null;
            }
            return TestsUtility.ofAnova((OneWayAnova)rtest.getEvolutiveSeasonalityTest()).getPvalue();
        });
        this.set("seas-res-stable", Double.class, source -> {
            CombinedSeasonality rtest = source.residualsTest(false);
            if (rtest == null) {
                return null;
            }
            return TestsUtility.ofAnova((OneWayAnova)rtest.getStableSeasonalityTest()).getPvalue();
        });
        this.set("seas-i-combined", String.class, source -> {
            CombinedSeasonality itest = source.irrTest(false);
            if (itest == null) {
                return null;
            }
            return itest.getSummary().name();
        });
        this.set("seas-i-combined3", String.class, source -> {
            CombinedSeasonality itest = source.irrTest(true);
            if (itest == null) {
                return null;
            }
            return itest.getSummary().name();
        });
        this.set("seas-i-evolutive", Double.class, source -> {
            CombinedSeasonality itest = source.irrTest(false);
            if (itest == null) {
                return null;
            }
            return TestsUtility.ofAnova((OneWayAnova)itest.getEvolutiveSeasonalityTest()).getPvalue();
        });
        this.set("seas-i-stable", Double.class, source -> {
            CombinedSeasonality itest = source.irrTest(false);
            if (itest == null) {
                return null;
            }
            return TestsUtility.ofAnova((OneWayAnova)itest.getStableSeasonalityTest()).getPvalue();
        });
        this.set("seas-sa-combined", String.class, source -> {
            CombinedSeasonality satest = source.saTest(false);
            if (satest == null) {
                return null;
            }
            return satest.getSummary().name();
        });
        this.set("seas-sa-combined3", String.class, source -> {
            CombinedSeasonality satest = source.saTest(true);
            if (satest == null) {
                return null;
            }
            return satest.getSummary().name();
        });
        this.set("seas-sa-evolutive", Double.class, source -> {
            CombinedSeasonality satest = source.saTest(false);
            if (satest == null) {
                return null;
            }
            return TestsUtility.ofAnova((OneWayAnova)satest.getEvolutiveSeasonalityTest()).getPvalue();
        });
        this.set("seas-sa-stable", Double.class, source -> {
            CombinedSeasonality satest = source.saTest(false);
            if (satest == null) {
                return null;
            }
            return TestsUtility.ofAnova((OneWayAnova)satest.getStableSeasonalityTest()).getPvalue();
        });
    }
}

