% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendars.R
\name{fixed_week_day}
\alias{fixed_week_day}
\title{Set a Holiday on a Fixed Week Day}
\usage{
fixed_week_day(month, week, dayofweek, weight = 1, validity = NULL)
}
\arguments{
\item{month}{month of the holiday: from \code{1} (January) to \code{12} (December).}

\item{week}{position of the specified week day in the month: from \code{1} (first week of the month) to \code{5}. Should be always lower than 5.
\code{-1} for the last \code{dayofweek} of the month.}

\item{dayofweek}{day of the week: from \code{1} (Monday) to \code{7} (Sunday).}

\item{weight}{weight associated to the holiday.}

\item{validity}{validity period: either \code{NULL} (full sample) or a named list
with \code{"start"} and/or "end" dates in the format \code{"YYYY-MM-DD"}.}
}
\value{
returns an object of class \code{c("JD3_FIXEDWEEKDAY","JD3_HOLIDAY")}
}
\description{
Allows to define a holiday falling on a fixed week day each year, like Labour Day in the
USA which is always celebrated on the first Monday of September.
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
day <- fixed_week_day(9, 1, 1) # first Monday(1) of September.
day
\dontshow{\}) # examplesIf}
}
\references{
More information on calendar correction in JDemetra+ online documentation:
\url{https://jdemetra-new-documentation.netlify.app/a-calendar-correction}
}
\seealso{
\code{\link{national_calendar}}, \code{\link{fixed_day}},\code{\link{special_day}},\code{\link{easter_day}}
}
