% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tramoseats.R
\name{tramoseats}
\alias{tramoseats}
\alias{tramoseats_fast}
\alias{.jtramoseats}
\title{Seasonal Adjustment with  TRAMO-SEATS}
\usage{
tramoseats(
  ts,
  spec = c("rsafull", "rsa0", "rsa1", "rsa2", "rsa3", "rsa4", "rsa5"),
  context = NULL,
  userdefined = NULL
)

tramoseats_fast(
  ts,
  spec = c("rsafull", "rsa0", "rsa1", "rsa2", "rsa3", "rsa4", "rsa5"),
  context = NULL,
  userdefined = NULL
)

.jtramoseats(
  ts,
  spec = c("rsafull", "rsa0", "rsa1", "rsa2", "rsa3", "rsa4", "rsa5"),
  context = NULL,
  userdefined = NULL
)
}
\arguments{
\item{ts}{a univariate time series.}

\item{spec}{the model specification. Can be either the name of a predefined
specification or a user-defined specification.}

\item{context}{the dictionary of variables.}

\item{userdefined}{a vector containing the additional output variables
(see \code{\link[=tramoseats_dictionary]{tramoseats_dictionary()}}).}
}
\value{
The \code{tramoseats()} function returns a list with the results, the
estimation specification and the result specification, while
\code{tramoseats_fast()} is a faster function that only returns the results.
The \code{.jtramoseats()} functions only results the java object to custom outputs
in other packages (use \code{\link[rjd3toolkit:dictionary]{rjd3toolkit::dictionary()}} to get the list of
variables and \code{\link[rjd3toolkit:dictionary]{rjd3toolkit::result()}} to get a specific variable).
}
\description{
Seasonal Adjustment with  TRAMO-SEATS
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
library("rjd3toolkit")

sp <- tramoseats_spec("rsafull")
y <- rjd3toolkit::ABS$X0.2.09.10.M
\donttest{
tramoseats(y, spec = sp)
tramoseats_fast(y, spec = sp)
}
sp <- add_outlier(sp,
    type = c("AO"), c("2015-01-01", "2010-01-01")
)
sp <- set_transform(
    set_tradingdays(
        set_easter(sp, enabled = FALSE),
        option = "workingdays"
    ),
    fun = "None"
)
\donttest{
tramoseats(y, spec = sp)
tramoseats_fast(y, spec = sp)
}
\dontshow{\}) # examplesIf}
}
