% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chartOptionsFormat.R
\name{chartOptionsFormat}
\alias{chartOptionsFormat}
\alias{chartOptionsFormat,Chart-method}
\title{Modifies the font settings for a \code{\link{Chart-class}}}
\usage{
chartOptionsFormat(
  chart,
  noDataAsZero = NULL,
  showDataPoints = NULL,
  showDataPointsOnly = NULL,
  showPanelTitles = NULL,
  showToolTips = NULL,
  showNoDataPanels = NULL,
  lineWidth = NULL
)

\S4method{chartOptionsFormat}{Chart}(
  chart,
  noDataAsZero = NULL,
  showDataPoints = NULL,
  showDataPointsOnly = NULL,
  showPanelTitles = NULL,
  showToolTips = NULL,
  showNoDataPanels = NULL,
  lineWidth = NULL
)
}
\arguments{
\item{chart}{\code{\link{Chart-class}} object}

\item{noDataAsZero}{logical. Determines whether NA, Null and No Data values
should be charted as zero. Default is \code{NULL}.}

\item{showDataPoints}{logical. Determines whether each data point should be
displayed with a point (i.e., circle). Default is \code{NULL}.}

\item{showDataPointsOnly}{logical. Determines whether only points should be
displayed (i.e., no line in the line charts). Default is \code{NULL}.}

\item{showPanelTitles}{logical. Determines whether to show a title above each
panel. Default is \code{NULL}.}

\item{showToolTips}{logical. Determines whether to show the tool tip when
hovering the cursor over a data point. Default is \code{NULL}.}

\item{showNoDataPanels}{logical. Determines whether to show chart panels
with no data. Default is \code{NULL}.}

\item{lineWidth}{integer. Sets the charts' line thickness. Default
is \code{NULL}.}
}
\value{
A \code{Chart} object representing a SyncroSim chart or, if no arguments
other than the chart are provided, a data.frame of the current chart format
settings.
}
\description{
Modifies the font style and size of various \code{\link{Chart-class}} components.
}
\examples{
\dontrun{
# Open a chart object
myChart <- chart(myProject, chart = "My Chart")

# Set the format for the chart panels
myChart <- chartOptionsFormat(myChart, noDataAsZero = TRUE, 
                              showDataPoints = FALSE, 
                              showDataPointsOnly = FALSE,
                              showPanelTitles = TRUE,
                              showToolTips = TRUE,
                              showNoDataPanels = FALSE,
                              lineWidth = 1)

# Return a dataframe of the current font settings
myChart <- chartOptionsFormat(myChart)
}

}
