% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chartOptionsXAxis.R
\name{chartOptionsXAxis}
\alias{chartOptionsXAxis}
\alias{chartOptionsXAxis,Chart-method}
\title{Modify the X Axis of a \code{\link{Chart-class}}}
\usage{
chartOptionsXAxis(
  chart,
  title = NULL,
  numberStyle = NULL,
  decimals = NULL,
  thousandsSeparator = NULL
)

\S4method{chartOptionsXAxis}{Chart}(
  chart,
  title = NULL,
  numberStyle = NULL,
  decimals = NULL,
  thousandsSeparator = NULL
)
}
\arguments{
\item{chart}{\code{\link{Chart-class}} object}

\item{title}{character. Title of the X Axis. Default is \code{NULL}.}

\item{numberStyle}{character. Sets the style for the axes labels. Options
include "number", scientific", or "currency". Default is \code{NULL}.}

\item{decimals}{float. Sets the number of decimal places to be displayed in
the axes labels. Values can be between 0 and 8. Default is \code{NULL}.}

\item{thousandsSeparator}{logical. Whether to use a thousand separator
(i.e., 1,000,000). Default is \code{NULL}.}
}
\value{
A \code{Chart} object representing a SyncroSim chart or, if no arguments
other than the chart are provided, a data.frame of the current chart X Axis
settings.
}
\description{
Set the title and style of the X Axis of a \code{\link{Chart-class}}.
}
\examples{
\dontrun{
# Open a chart object
myChart <- chart(myProject, chart = "My Chart")

# Set the chart X Axis title
myChart <- chartOptionsXAxis(myChart, title = "Year")

# Return a dataframe of the current X Axis settings
myChart <- chartOptionsXAxis(myChart)
}

}
