% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CM.R
\name{CM2SOM}
\alias{CM2SOM}
\title{Convert conditioning model to operating model}
\usage{
CM2SOM(stanfit, sims, nsim = 2, seed = 1, proyears = 40)
}
\arguments{
\item{stanfit}{Output from \code{\link[=sample_CM]{sample_CM()}}}

\item{sims}{Optional, a vector of integers indicating the MCMC iterations to convert to operating model simulations. Otherwise,
use argument \code{nsim} in order to sample a subset of the MCMC.}

\item{nsim}{Integer, total number of simulations in the operating model. Only used if \code{sims} is missing.}

\item{seed}{Integer, seed for sampling the MCMC output. Only used if \code{sims} is missing.}

\item{proyears}{Integer, the number of projection years in the operating model}
}
\value{
\linkS4class{SOM} object.
}
\description{
Creates an operating model from MCMC samples and data inputs of the conditioning model.
Management actions for habitat, hatchery production, and harvest still need to be specified in the operating model.
}
