% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define-SOM.R
\docType{class}
\name{Harvest-class}
\alias{Harvest-class}
\title{Class \code{"Harvest"}}
\description{
The component of the operating model that controls harvest.
}
\section{Slots}{

\describe{
\item{\code{Name}}{Character. Identifying name}

\item{\code{type_PT}}{Character. Whether to manage preterminal fishery catch from exploitation rate ("u") or catch target ("catch"). Default is "u",}

\item{\code{type_T}}{Character. Whether to manage terminal fishery catch from exploitation rate ("u") or catch target ("catch"). Default is "u",}

\item{\code{u_preterminal}}{Numeric. If \code{type_PT = "u"}, the exploitation rate of the immature stock in the pre-terminal fishery. This will be converted
to an instantaneous fishing mortality rate, i.e., \code{F_preterminal = -log(1 - u_preterminal)}.}

\item{\code{u_terminal}}{Numeric. If \code{type_T = "u"}, The exploitation rate of the return in the terminal fishery. This will be converted
to an instantaneous fishing mortality rate, i.e., \code{F_terminal = -log(1 - u_terminal)}.}

\item{\code{K_PT}}{Numeric. If \code{type_PT = "catch"}, the catch target of the immature stock in the pre-terminal fishery.}

\item{\code{K_T}}{Numeric. If \code{type_T = "catch"}, the catch target of the return in the terminal fishery.}

\item{\code{MSF_PT}}{Logical. Whether to implement mark-selective fishing in the preterminal fishery, with no retention on unmarked fish.}

\item{\code{MSF_T}}{Logical. Whether to implement mark-selective fishing in the terminal fishery, with no retention on unmarked fish.}

\item{\code{release_mort}}{Vector length 2. The proportion of released fish that die after release, in the pre-terminal and terminal fishery.
Implemented to model mark-selective fishing. Not used if either \code{MSF_PT} or \code{MSF_T} is \code{ FALSE}.}

\item{\code{vulPT}}{Vector length \code{maxage} or matrix \verb{[nsim, maxage]}. Vulnerability schedule (between 0-1) in the preterminal fishery. Values indicate
the proportion of fishing mortality experienced by each age class, where \code{F_preterminal = -log(1 - u_preterminal)}.}

\item{\code{vulT}}{Vector length \code{maxage} or matrix \verb{[nsim, maxage]}. Vulnerability schedule (between 0-1) in the terminal fishery. Values indicate
the proportion of fishing mortality experienced by each age class, where \code{F_terminal = -log(1 - u_terminal)}.}
}}

\section{Creating Object}{

Objects can be created by calls of the form \code{new("Harvest")}
}

\examples{
showClass("Harvest")
}
\keyword{classes}
