% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref.R
\name{calc_Smsy_Ricker}
\alias{calc_Smsy_Ricker}
\alias{calc_Umsy_Ricker}
\alias{calc_Sgen_Ricker}
\title{Ricker reference points}
\usage{
calc_Smsy_Ricker(loga, b)

calc_Umsy_Ricker(loga)

calc_Sgen_Ricker(loga, b)
}
\arguments{
\item{loga}{Numeric, alpha parameter (returns per spawner) in the Ricker function: \eqn{R=S\exp(\log(a)-bS)}
where \code{S} is the number of spawners and \code{R} is the return}

\item{b}{Numeric, beta parameter}
}
\value{
All three functions return a numeric
}
\description{
Compute reference points (Umsy, Smsy, and Sgen) from Ricker stock-recruit function
based on Scheuerell (2016).
}
\references{
Scheuerell, M.D. 2016. An explicit solution for
calculating optimum spawning stock size from Ricker’s stock recruitment model. PeerJ 4:e1623. \doi{10.7717/peerj.1623}
}
\seealso{
\code{\link[=calc_ref]{calc_ref()}}
}
