% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels-single.R
\name{lbl_seq}
\alias{lbl_seq}
\title{Label chopped intervals in sequence}
\usage{
lbl_seq(start = "a")
}
\arguments{
\item{start}{String. A template for the sequence. See below.}
}
\value{
A function that creates a vector of labels.
}
\description{
\code{lbl_seq()} labels intervals sequentially, using numbers or letters.
}
\details{
\code{start} shows the first element of the sequence. It must contain exactly \emph{one}
character out of the set "a", "A", "i", "I" or "1". For later elements:
\itemize{
\item "a" will be replaced by "a", "b", "c", ...
\item "A" will be replaced by "A", "B", "C", ...
\item "i" will be replaced by lower-case Roman numerals "i", "ii", "iii", ...
\item "I" will be replaced by upper-case Roman numerals "I", "II", "III", ...
\item "1" will be replaced by numbers "1", "2", "3", ...
}

Other characters will be retained as-is.
}
\examples{
chop(1:10, c(2, 5, 8), lbl_seq())

chop(1:10, c(2, 5, 8), lbl_seq("i."))

chop(1:10, c(2, 5, 8), lbl_seq("(A)"))
}
\seealso{
Other labelling functions: 
\code{\link{lbl_dash}()},
\code{\link{lbl_discrete}()},
\code{\link{lbl_endpoints}()},
\code{\link{lbl_glue}()},
\code{\link{lbl_intervals}()},
\code{\link{lbl_manual}()},
\code{\link{lbl_midpoints}()}
}
\concept{labelling functions}
