% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smvalues.R
\name{smvalues}
\alias{smvalues}
\alias{smvalues_wsum}
\title{Compute Score Matching Discrepancy Value, Gradient, and Hessian}
\usage{
smvalues(smdtape, xmat, pmat, xcentres = NA * xmat, approxorder = 10)

smvalues_wsum(
  tape,
  xmat,
  pmat,
  w = NULL,
  xcentres = NA * xmat,
  approxorder = 10
)
}
\arguments{
\item{smdtape}{A taped score matching discrepancy. Most easily created by \code{\link[=tape_smd]{tape_smd()}}.}

\item{xmat}{A matrix of (multivariate) independent variables where each represents a single independent variable vector. Or a single independent variable vector that is used for all rows of \code{pmat}.}

\item{pmat}{A matrix of dynamic parameters where each row specifies a new set of values for the dynamic parameters of \code{tape}. Or a single vector of dynamic parameters to use for all rows of \code{xmat}.}

\item{xcentres}{A matrix of approximation for Taylor approximation centres for \code{xmat}. Use values of \code{NA} for rows that do not require Taylor approximation.}

\item{approxorder}{Order of Taylor approximation}

\item{tape}{An \code{\link{Rcpp_ADFun}} object (i.e. a tape of a function).}

\item{w}{Weights to apply to each row of \code{xmat} for computing the weighted sum. If \code{NULL} then each row is given a weight of \code{1}.}
}
\value{
A list of
\itemize{
\item \code{obj} the score matching discrepancy values
\item \code{grad} the gradient of the score matching discrepancy
\item \code{hess} the Hessian of the score matching discrepancy
}
}
\description{
Computes a range of relevant information for investigating score matching estimators.
}
\details{
Computes the score matching discrepancy function from \code{\link{scorematchingtheory}} or weighted sum of the score matching discrepancy function.
The gradient and Hessian are returned as arrays of row-vectors with each row corresponding to a row in \code{xmat} and \code{pmat}.
Convert a Hessian row-vector to a matrix using \code{matrix(ncol = length(smdtape$xtape))}.
}
\examples{
m <- rppi_egmodel(100)
smdtape <- tape_smd("sim", "sqrt", "sph", "ppi",
              ytape = rep(1/m$p, m$p),
              usertheta = ppi_paramvec(beta = m$beta),
              bdryw = "minsq", acut = 0.01)$smdtape
smvalues(smdtape, xmat = m$sample, pmat = m$theta[1:5])
smvalues_wsum(smdtape, m$sample, m$theta[1:5])$grad/nrow(m$sample)
}
\seealso{
Other tape evaluators: 
\code{\link{evaltape}()},
\code{\link{quadratictape_parts}()},
\code{\link{testquadratic}()}
}
\concept{tape evaluators}
