% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.check_normality.R
\name{plot.see_check_normality}
\alias{plot.see_check_normality}
\title{Plot method for check model for (non-)normality of residuals}
\usage{
\method{plot}{see_check_normality}(
  x,
  type = "qq",
  data = NULL,
  linewidth = 0.8,
  size_point = 2,
  size_title = 12,
  size_axis_title = base_size,
  base_size = 10,
  alpha = 0.2,
  alpha_dot = 0.8,
  theme = NULL,
  colors = c("#3aaf85", "#1b6ca8"),
  detrend = TRUE,
  method = "ell",
  ...
)
}
\arguments{
\item{x}{An object.}

\item{type}{Character vector, indicating the type of plot.
Options are \code{"qq"} (default) for quantile-quantile (Q-Q) plots,
\code{"pp"} for probability-probability (P-P) plots, or
\code{"density"} for density overlay plots.}

\item{data}{The original data used to create this object. Can be a
statistical model.}

\item{linewidth}{Numeric value specifying size of line geoms.}

\item{size_point}{Numeric specifying size of point-geoms.}

\item{base_size, size_axis_title, size_title}{Numeric value specifying size of
axis and plot titles.}

\item{alpha}{Numeric value specifying alpha level of the confidence bands.}

\item{alpha_dot}{Numeric value specifying alpha level of the point geoms.}

\item{theme}{A ggplot2-theme function, e.g. \code{theme = theme_lucid()} or
\code{theme = ggplot2::theme_dark()}.}

\item{colors}{Character vector of length two, indicating the colors (in
hex-format) for points and line.}

\item{detrend}{Logical that decides if Q-Q and P-P plots should be de-trended
(also known as \emph{worm plots}).}

\item{method}{The method used for estimating the qq/pp bands. Default to
\code{"ell"} (equal local levels / simultaneous testing - recommended). Can also
be one of \code{"pointwise"} or \code{"boot"} for pointwise confidence bands, or
\code{"ks"} or \code{"ts"} for simultaneous testing. See \code{qqplotr::stat_qq_band()}
for details.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{performance::check_normality()}
function.
}
\examples{
library(performance)

m <<- lm(mpg ~ wt + cyl + gear + disp, data = mtcars)
result <- check_normality(m)
plot(result)

\dontshow{if (require("qqplotr")) withAutoprint(\{ # examplesIf}
plot(result, type = "qq", detrend = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
See also the vignette about \href{https://easystats.github.io/performance/articles/check_model.html}{\code{check_model()}}.
}
