% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.parameters_pca.R
\name{plot.see_parameters_pca}
\alias{plot.see_parameters_pca}
\title{Plot method for principal component analysis}
\usage{
\method{plot}{see_parameters_pca}(
  x,
  type = c("bar", "line"),
  size_text = 3.5,
  color_text = "black",
  size = 1,
  show_labels = TRUE,
  ...
)
}
\arguments{
\item{x}{An object.}

\item{type}{Character vector, indicating the type of plot. Options are three
different shapes to represent component loadings; \code{"bar"} (default) for a
horizontal bar chart, or \code{"line"} for a horizontal point and line chart.}

\item{size_text}{Numeric value specifying size of text labels.}

\item{color_text}{Character specifying color of text labels.}

\item{size}{Depending on \code{type}, a numeric value specifying size of bars,
lines, or segments.}

\item{show_labels}{Logical. If \code{TRUE}, text labels are displayed.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{parameters::principal_components()} function.
}
\examples{
library(parameters)
data(mtcars)
result <- principal_components(mtcars[, 1:7], n = "all", threshold = 0.2)
result
plot(result)

}
