% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{perplexity}
\alias{perplexity}
\title{Optimize the hyper-parameters for LDA}
\usage{
perplexity(x, newdata = NULL, ...)
}
\arguments{
\item{x}{a LDA model fitted by \code{\link[=textmodel_seededlda]{textmodel_seededlda()}} or \code{\link[=textmodel_lda]{textmodel_lda()}}.}

\item{newdata}{if provided, \code{theta} and \code{phi} are estimated through fresh
Gibbs sampling.}

\item{...}{additional arguments passed to \link{textmodel_lda}.}
}
\value{
Returns a singple numeric value.
}
\description{
\code{perplexity()} computes the perplexity score to help users to chose the
optimal values of hyper-parameters for LDA.
}
\details{
\code{perplexity()} predicts the distribution of words in the dfm based
on \code{x$alpha} and \code{x$gamma} and then compute the sum of disparity between their
predicted and observed frequencies. The perplexity score minimizes when the
chosen values of hyper-parameters such as \code{k}, \code{alpha} and \code{gamma} are
optimal.
}
\seealso{
\link{divergence}
}
