% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_sbt_ustd_boot.R
\name{print.sbt_ustd_boot}
\alias{print.sbt_ustd_boot}
\title{Print a 'sbt_ustd_boot' Object}
\usage{
\method{print}{sbt_ustd_boot}(
  x,
  ...,
  nd = 3,
  output = c("lavaan.printer", "text", "table"),
  drop_cols = "Z"
)
}
\arguments{
\item{x}{Object of the class
\code{sbt_ustd_boot}, the output of
\code{\link[=parameterEstimates_boot]{parameterEstimates_boot()}}.}

\item{...}{Optional arguments to be
passed to \code{\link[=print]{print()}} methods.}

\item{nd}{The number of digits
after the decimal place. Default
is 3.}

\item{output}{String. How the results
are printed. If set to \code{"table"},
the results are printed in a table
format similar to that of
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}.
If set to \code{"text"}, the results will be
printed in a text format similar to
the printout of the output of
\code{\link[=summary]{summary()}} of
a 'lavaan'-class object. If set
to \code{"lavaan.printer"}, the default,
\code{lavaan.printer}
will be used to print a more compact
version of the \code{"text"} output.}

\item{drop_cols}{The name(s) of the
column(s) to drop
if output format is \code{"lavaan.printer"}.
Default is \code{"Z"}, to fit the print
out to the usual screen width of 80.}
}
\value{
\code{x} is returned invisibly. Called for its side effect.
}
\description{
Print method for a
'sbt_ustd_boot' object, which
is the output of
\code{\link[=parameterEstimates_boot]{parameterEstimates_boot()}}.
}
\details{
The default format of the printout,
\code{"lavaan.printer"},
is a compact version of the lavaan-style
printout, generated by \code{lavaan.printer}.
Alternatively, users can request a format
similar to that of the printout
of the summary of a \code{lavaan} output
by setting \code{output} to \code{"text"}. This
format can be used if \code{"lavaan.printer"}
failed.

Users can also print the content just
as a data frame by setting \code{output}
to \code{"table"}. Not easy to read much
more compact.
}
\examples{
library(lavaan)
set.seed(5478374)
n <- 50
x <- runif(n) - .5
m <- .40 * x + rnorm(n, 0, sqrt(1 - .40))
y <- .30 * m + rnorm(n, 0, sqrt(1 - .30))
dat <- data.frame(x = x, y = y, m = m)
model <-
'
m ~ a*x
y ~ b*m
ab := a*b
'

# Should set bootstrap to at least 2000 in real studies
fit <- sem(model, data = dat, fixed.x = FALSE)

fit <- store_boot(fit,
                  do_bootstrapping = TRUE,
                  R = 100,
                  iseed = 1234)

est <- parameterEstimates_boot(fit)
est

}
\seealso{
\code{\link[=parameterEstimates_boot]{parameterEstimates_boot()}}
}
\author{
Shu Fai Cheung
\url{https://orcid.org/0000-0002-9871-9448}
}
