% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_cvpat.R
\name{assess_cvpat_compare}
\alias{assess_cvpat_compare}
\title{SEMinR function to compare CVPAT loss of two models}
\usage{
assess_cvpat_compare(
  established_model,
  alternative_model,
  testtype = "two.sided",
  nboot = 2000,
  seed = 123,
  technique = predict_DA,
  noFolds = NULL,
  reps = NULL,
  cores = NULL
)
}
\arguments{
\item{established_model}{The base seminr model for CVPAT comparison.}

\item{alternative_model}{The alternate seminr model for CVPAT comparison.}

\item{testtype}{Either "two.sided" (default) or "greater".}

\item{nboot}{The number of bootstrap subsamples to execute (defaults to 2000).}

\item{seed}{The seed for reproducibility (defaults to 123).}

\item{technique}{predict_EA or predict_DA (default).}

\item{noFolds}{Mumber of folds for k-fold cross validation.}

\item{reps}{Number of repetitions for cross validation.}

\item{cores}{Number of cores for parallelization.}
}
\value{
A matrix of the estimated loss and results of significance testing.
}
\description{
`assess_cvpat_compare` conducts a CVPAT significance test of loss between
two models.
}
\examples{
# Load libraries
library(seminr)


}
\references{
Sharma, P. N., Liengaard, B. D., Hair, J. F., Sarstedt, M., &
Ringle, C. M. (2022). Predictive model assessment and selection in
composite-based modeling using PLS-SEM: extensions and guidelines for
using CVPAT. European journal of marketing, 57(6), 1662-1677.

Liengaard, B. D., Sharma, P. N., Hult, G. T. M., Jensen, M. B.,
Sarstedt, M., Hair, J. F., & Ringle, C. M. (2021). Prediction: coveted,
yet forsaken? Introducing a cross‐validated predictive ability test in
partial least squares path modeling. Decision Sciences, 52(2), 362-392.
}
