% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_mnhmm.R
\name{simulate_mnhmm}
\alias{simulate_mnhmm}
\title{Simulate Mixture Non-homogeneous Hidden Markov Models}
\usage{
simulate_mnhmm(
  n_states,
  n_clusters,
  emission_formula,
  initial_formula = ~1,
  transition_formula = ~1,
  cluster_formula = ~1,
  data,
  id,
  time,
  coefs = NULL,
  init_sd = 2 * is.null(coefs),
  check_rank = NULL
)
}
\arguments{
\item{n_states}{An integer > 1 defining the number of hidden states.}

\item{n_clusters}{The number of clusters/mixtures.}

\item{emission_formula}{of class \code{\link[=formula]{formula()}} for the
state emission probabilities, or a list of such formulas in case of multiple
response variables. The left-hand side of formulas define the responses.
For multiple responses having same formula, you can use a form
\code{c(y1, y2) ~ x}, where \code{y1} and \code{y2} are the response variables.}

\item{initial_formula}{of class \code{\link[=formula]{formula()}} for the
initial state probabilities. Left-hand side of the formula should be empty.}

\item{transition_formula}{of class \code{\link[=formula]{formula()}} for the state transition
probabilities. Left-hand side of the formula should be empty.}

\item{cluster_formula}{of class \code{\link[=formula]{formula()}} for the mixture probabilities.}

\item{data}{A data frame containing the variables used in the model
formulas. Note that this should also include also the response variable(s),
which are used to define the number of observed symbols (using \code{\link[=levels]{levels()}})
and the length of sequences. The actual values of the response variables
does not matter though, as they are replaced by the simulated values. The
exception is the first time point in FAN-HMM case: If the \code{emission_formula}
contains lagged responses, the response variable values at the first time
point are used to define the emissions at the second time point, and the
simulations are done from the second time point onward. This matches the
case \code{prior_obs = "fixed"} in \code{\link[=estimate_nhmm]{estimate_nhmm()}}. Note that compared to
\verb{estimate_*} functions, unused factor levels are not automatically dropped
from \code{data}.}

\item{id}{Name of the id variable in \code{data} identifying different
sequences.}

\item{time}{Name of the time index variable in \code{data}.}

\item{coefs}{Same as argument \code{inits} in \code{\link[=estimate_mnhmm]{estimate_mnhmm()}}. If \code{NULL},
(default), the model parameters are generated randomly. If you want to
simulate new sequences based on an estimated model \code{fit}, you can use
\code{coefs = fit$etas} and \code{init_sd = 0}.}

\item{init_sd}{Standard deviation of the normal distribution used to
generate random coefficients. Default is \code{2} when \code{coefs} is \code{NULL} and \code{0}
otherwise.}

\item{check_rank}{If \code{TRUE}, the rank of the design matrices are
checked for identifiability issues. Default is \code{NULL}, in which case checks
are performed only if the number of sequences is 1000 or less, as the QR
decomposition quickly becomes computationally demanding. If check is not
performed, a warning is given, which can be circumvented by explicitly
using \code{check_rank = FALSE}.}
}
\value{
A list with the model used in simulation as well as the simulated
hidden state sequences.
}
\description{
Simulate sequences of observed and hidden states given the parameters of a
mixture non-homogeneous hidden Markov model.
}
