% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_get_Blocks.R
\name{get_block}
\alias{get_block}
\title{get_block generic}
\usage{
get_block(
  x,
  labels = "default",
  node_names = NULL,
  attribution = TRUE,
  proportion = FALSE
)
}
\arguments{
\item{x}{Sbm model of class `BipartiteSBM_fit`, `SimpleSBM_fit`.}

\item{labels}{labels for nodes. If it's simple sbm it should be a single character ("default" -> c("nodes")). If sbm is bipartite a named character (names are row and col) ("default" -> c(row = 'row', col = 'col')).}

\item{node_names}{\describe{
\item{"bipartite case": }{named list ("row","col"), row is a character vector containing names of nodes in rows, and respectively for columns}
\item{"unipartite case": }{character: node names}
}}

\item{attribution}{Boolean indicating whether or not the produced tables should contain a block attribution column. This column shows the block in which each nodes is the most likely to be.}

\item{proportion}{Boolean indicating whether or not the produced tables should contain the probabilities to belong in each blocks. These columns shows for every nodes and every blocks the probabilities that the node belong to the block.}
}
\value{
\describe{
 \item{"bipartite case": }{A list containing two data.frames with block attributions and/or proportions one for the row blocks and one for the column blocks}
 \item{"unipartite case": }{A data.frame with block attributions and/or proportions}
 }
}
\description{
A fct that return blocks attribution or probabilities for each nodes in a Sbm fit from the \pkg{sbm} package.
}
\examples{

# my_sbm_bi <- sbm::estimateBipartiteSBM(sbm::fungusTreeNetwork$fungus_tree,
#                                        model = 'bernoulli')
my_sbm_bi <- FungusTreeNetwork$sbmResults$fungus_tree

node_names_bi <- list(
  row = FungusTreeNetwork$networks$fungus_names,
  col = FungusTreeNetwork$networks$tree_names
)

my_blocks_bi <- get_block(my_sbm_bi,
  labels = c(row = "Fungus", col = "Tree"),
  node_names = node_names_bi
)
my_blocks_bi$row
my_blocks_bi$col

# my_sbm_uni <- sbm::estimateSimpleSBM(sbm::fungusTreeNetwork$tree_tree,
#                                      model = "poisson")
my_sbm_uni <- FungusTreeNetwork$sbmResults$tree_tree

node_names_uni <- list(FungusTreeNetwork$networks$tree_names)

my_blocks_uni <- get_block(my_sbm_uni,
  labels = c("Tree"),
  node_names = node_names_uni
)
my_blocks_uni
}
