% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_shiny_testers.R
\name{use_shiny_testers}
\alias{use_shiny_testers}
\alias{with_shiny_testers}
\title{Use Shiny Testers}
\usage{
use_shiny_testers(..., .package = "shiny", .env = rlang::caller_env())

with_shiny_testers(code, ..., .package = "shiny")
}
\arguments{
\item{...}{Arguments passed to \code{\link{create_test_update_fns}}}

\item{.package}{Character string of the package that the update functions exist in.
Default is `"shiny"`}

\item{.env}{Environment that defines effect scope. For expert use only.}

\item{code}{Code to execute with specified bindings.}
}
\value{
Implicit return of the updated functions in the supplied package within
the specified environment.
}
\description{
Enable `update` functions in the Shiny or Shiny extension package to be mocked in tests.
}
\examples{
library(shiny)
library(testthat)

example_server_fn <- function(input, output, session) {
  observeEvent(input$trigger, {
      updateTextInput(
      inputId = "result",
      label = "New Label",
      value = NULL,
      placeholder = "New placeholder"
    )
  })
}

test_that("Check that text input gets updated", {
  use_shiny_testers()

  shiny::testServer(
    app = example_server_fn,
    expr = {
      session$setInputs(result = "Example text")
      session$setInputs(trigger = 1L)

      expect_identical(input$result, "Example text")
      expect_identical(input$result.label, "New Label")
      expect_identical(input$result.placeholder, "New placeholder")
    }
  )
})

}
