% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizationFunction.R
\name{normalizeData}
\alias{normalizeData}
\title{Normalization of given data}
\usage{
normalizeData(dataInput, dataInputName = NA)
}
\arguments{
\item{dataInput}{A dataframe or a list containing the dataframe. The data frame should be composed of at least two columns. One represents time, and the other represents intensity.}

\item{dataInputName}{experiment name (Default is 'NA').}
}
\value{
Function returns a new dataframe, scaling factors and scaling constants that connects the initial data frame to the new one. The new data frame includes 2 columns: normalized time and normalized intensity. The time and intensity constants and scaling factors are the parameters to transform data from the unnormalized dataframe to normalized data frame.
}
\description{
Maps the given time-intensity data into a rescaled dataframe where time is scaled to between 0 and 1, and intensity is scaled to be between 0 and 1.
}
\examples{
# runif() is used here for consistency with previous versions of the sicegar package. However,
# rnorm() will generate symmetric errors, producing less biased numerical parameter estimates.
# We recommend errors generated with rnorm() for any simulation studies on sicegar.
# generateRandomData
time <- seq(3, 48, 0.5)
intensity <- runif(length(time), 3.0, 7.5)
dataInput <- data.frame(time, intensity)

# Normalize Data
dataOutput <- normalizeData(dataInput, dataInputName="sample001")

}
