% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-stand-level.R
\name{silv_stand_basal_area}
\alias{silv_stand_basal_area}
\title{Calculates Basal Area}
\usage{
silv_stand_basal_area(diameter, ntrees = NULL, units = "cm")
}
\arguments{
\item{diameter}{Numeric vector of diameters or diameter classes}

\item{ntrees}{Numeric vector with number of trees of the diameter class per
hectare. If \code{ntrees = NULL}, the function will assume that each diameter
corresponds to only one tree}

\item{units}{The units of the diameter (one of \code{mm}, \code{cm}, \code{dm}, or \code{m})}
}
\value{
A numeric vector
}
\description{
Calculates Basal Area in square meters.
}
\details{
The function uses the next formula:

\eqn{G = \frac{\pi}{40000} \cdot D^2 \cdot \text{ntrees}}

where G is the basal area in \eqn{m^2}, and D is the diameter in \code{cm}. If ntrees
in the number of trees per hectare, then the result will be \eqn{m^2/ha}. It is
recommended to use the squared mean diameter calculated with \code{\link[=silv_stand_qmean_diameter]{silv_stand_qmean_diameter()}}.

Note that if \code{ntrees = NULL}, the output of the function will be exactly
the same as in \code{\link[=silv_tree_basal_area]{silv_tree_basal_area()}}.
}
\examples{
## calculate G for inventory data grouped by plot_id and species
library(dplyr)
inventory_samples |>
mutate(dclass = silv_tree_dclass(diameter)) |>
  summarise(
    height = mean(height, na.rm = TRUE),
    ntrees = n(),
    .by    = c(plot_id, species, dclass)
  ) |>
  mutate(
    ntrees_ha = silv_density_ntrees_ha(ntrees, plot_size = 10),
    dg        = silv_stand_qmean_diameter(dclass, ntrees_ha),
    g         = silv_stand_basal_area(dclass, ntrees_ha),
    .by       = c(plot_id, species)
  )
}
