% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generators.R
\name{vbinom}
\alias{vbinom}
\title{Variate Generation for Binomial Distribution}
\usage{
vbinom(n, size, prob, stream = NULL, antithetic = FALSE, asList = FALSE)
}
\arguments{
\item{n}{number of observations}

\item{size}{number of trials (zero or more)}

\item{prob}{probability of success on each trial (0 \eqn{<} \code{prob} \eqn{\le} 1)}

\item{stream}{if \code{NULL} (default), uses \code{\link[=runif]{stats::runif}}
to generate uniform variates to invert via
\code{\link[=qbinom]{stats::qbinom}};
otherwise, an integer in 1:25 indicates the \code{\link[rstream]{rstream}} stream
from which to generate uniform variates to invert via
\code{\link[=qbinom]{stats::qbinom}};}

\item{antithetic}{if \code{FALSE} (default), inverts \eqn{u} = uniform(0,1)
variate(s) generated via either \code{\link[=runif]{stats::runif}} or
\code{\link[rstream]{rstream.sample}}; otherwise, uses
\eqn{1 - u}}

\item{asList}{if \code{FALSE} (default), output only the generated
random variates; otherwise, return a list with components suitable for
visualizing inversion. See return for details}
}
\value{
If \code{asList} is FALSE (default), return a vector of random variates.

Otherwise, return a list with components suitable for visualizing inversion,
specifically:
\item{u}{        A vector of generated U(0,1) variates }
\item{x}{        A vector of binomial random variates }
\item{quantile}{ Parameterized quantile function }
\item{text}{     Parameterized title of distribution }
}
\description{
Variate Generation for Binomial Distribution
}
\details{
Generates random variates from the binomial distribution.

Binomial variates are generated by inverting uniform(0,1) variates
produced either by \code{\link[=runif]{stats::runif}} (if \code{stream} is
\code{NULL}) or by \code{\link[rstream]{rstream.sample}}
(if \code{stream} is not \code{NULL}).
In either case, \code{\link[=qbinom]{stats::qbinom}} is used to
invert the uniform(0,1) variate(s).
In this way, using \code{vbinom} provides a monotone and synchronized
binomial variate generator, although not particularly fast.

The stream indicated must be an integer between 1 and 25 inclusive.

The binomial distribution with parameters \code{size} = \eqn{n} and
\code{prob} = \eqn{p} has pmf
\deqn{p(x) = {n \choose x} p^x (1-p)^{(n-x)}}{%
                 p(x) = choose(n, x) p^x (1-p)^(n-x)}
for \eqn{x = 0, \ldots, n}.
}
\examples{
 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qbinom
 vbinom(3, size = 10, prob = 0.25)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qbinom
 vbinom(3, 10, 0.25, stream = 1)
 vbinom(3, 10, 0.25, stream = 2)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qbinom
 vbinom(1, 10, 0.25, stream = 1)
 vbinom(1, 10, 0.25, stream = 2)
 vbinom(1, 10, 0.25, stream = 1)
 vbinom(1, 10, 0.25, stream = 2)
 vbinom(1, 10, 0.25, stream = 1)
 vbinom(1, 10, 0.25, stream = 2)

 set.seed(8675309)
 variates <- vbinom(100, 10, 0.25, stream = 1)
 set.seed(8675309)
 variates <- vbinom(100, 10, 0.25, stream = 1, antithetic = TRUE)

}
\seealso{
\code{\link[rstream]{rstream}}, \code{\link{set.seed}},
\code{\link[=runif]{stats::runif}}

\code{\link[=rbinom]{stats::rbinom}}
}
\author{
Barry Lawson (\email{blawson@bates.edu}), \cr
Larry Leemis (\email{leemis@math.wm.edu}), \cr
Vadim Kudlay (\email{vkudlay@nvidia.com})
}
\concept{random variate generation}
\keyword{distribution}
