% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{eucalypts}
\alias{eucalypts}
\title{eucalypts}
\format{
A 'list': List of 3.
\describe{
\item{env}{data.frame with 7 environmental covariates}
\item{PA}{Presence-absence data for 12 eucalypts species}
\item{lat_lon}{Coordinates for the sites}
}
}
\source{
\doi{10.1111/2041-210x.12180}
}
\usage{
eucalypts
}
\description{
This dataset is from \doi{10.1111/2041-210x.12180}.
}
\details{
This is a dataset about butterfly communities. It consists of 458 sites and 12 species.
}
\examples{
\dontrun{
  PA = eucalypts$PA
  E = eucalypts$env
  LatLon = eucalypts$lat_lon
  
  m = sjSDM(PA, 
            scale(E), 
            spatial = DNN(scale(LatLon), formula = ~0+.), 
            se = TRUE,
            verbose = FALSE)
  summary(m)
  plot(m)
  
}
}
\author{
Maximilian Pichler
}
\keyword{datasets}
